
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Value.Kind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "boolValue"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class BoolValueKind implements Serializable, Kind
{

    /**
     * 
     */
    @JsonProperty("boolValue")
    @JsonPropertyDescription("")
    private Boolean boolValue;
    private final static long serialVersionUID = -6266165359371301273L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public BoolValueKind() {
    }

    /**
     * 
     * @param boolValue
     */
    public BoolValueKind(Boolean boolValue) {
        super();
        this.boolValue = boolValue;
    }

    /**
     * 
     */
    public Boolean getBoolValue() {
        return boolValue;
    }

    /**
     * 
     */
    public void setBoolValue(Boolean boolValue) {
        this.boolValue = boolValue;
    }

}
