package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BoolValueKindBuilder extends BoolValueKindFluentImpl<BoolValueKindBuilder> implements VisitableBuilder<BoolValueKind,BoolValueKindBuilder>{

    BoolValueKindFluent<?> fluent;
    Boolean validationEnabled;

    public BoolValueKindBuilder(){
            this(true);
    }
    public BoolValueKindBuilder(Boolean validationEnabled){
            this(new BoolValueKind(), validationEnabled);
    }
    public BoolValueKindBuilder(BoolValueKindFluent<?> fluent){
            this(fluent, true);
    }
    public BoolValueKindBuilder(BoolValueKindFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BoolValueKind(), validationEnabled);
    }
    public BoolValueKindBuilder(BoolValueKindFluent<?> fluent,BoolValueKind instance){
            this(fluent, instance, true);
    }
    public BoolValueKindBuilder(BoolValueKindFluent<?> fluent,BoolValueKind instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBoolValue(instance.getBoolValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public BoolValueKindBuilder(BoolValueKind instance){
            this(instance,true);
    }
    public BoolValueKindBuilder(BoolValueKind instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBoolValue(instance.getBoolValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public BoolValueKind build(){
            BoolValueKind buildable = new BoolValueKind(fluent.isBoolValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BoolValueKindBuilder that = (BoolValueKindBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
