package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class BoolValueKindFluentImpl<A extends BoolValueKindFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BoolValueKindFluent<A>{

    private Boolean boolValue;

    public BoolValueKindFluentImpl(){
    }
    public BoolValueKindFluentImpl(BoolValueKind instance){
            this.withBoolValue(instance.getBoolValue()); 
    }

    public Boolean isBoolValue(){
            return this.boolValue;
    }

    public A withBoolValue(Boolean boolValue){
            this.boolValue=boolValue; return (A) this;
    }

    public Boolean hasBoolValue(){
            return this.boolValue != null;
    }

    public A withNewBoolValue(String arg1){
            return (A)withBoolValue(new Boolean(arg1));
    }

    public A withNewBoolValue(boolean arg1){
            return (A)withBoolValue(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            BoolValueKindFluentImpl that = (BoolValueKindFluentImpl) o;
            if (boolValue != null ? !boolValue.equals(that.boolValue) :that.boolValue != null) return false;
            return true;
    }




}
