
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Int32Value implements Serializable
{

    /**
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("")
    private Integer value;
    private final static long serialVersionUID = -3524574225967853149L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Int32Value() {
    }

    /**
     * 
     * @param value
     */
    public Int32Value(Integer value) {
        super();
        this.value = value;
    }

    /**
     * 
     */
    public Integer getValue() {
        return value;
    }

    /**
     * 
     */
    public void setValue(Integer value) {
        this.value = value;
    }

}
