package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class Int32ValueBuilder extends Int32ValueFluentImpl<Int32ValueBuilder> implements VisitableBuilder<Int32Value,Int32ValueBuilder>{

    Int32ValueFluent<?> fluent;
    Boolean validationEnabled;

    public Int32ValueBuilder(){
            this(true);
    }
    public Int32ValueBuilder(Boolean validationEnabled){
            this(new Int32Value(), validationEnabled);
    }
    public Int32ValueBuilder(Int32ValueFluent<?> fluent){
            this(fluent, true);
    }
    public Int32ValueBuilder(Int32ValueFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Int32Value(), validationEnabled);
    }
    public Int32ValueBuilder(Int32ValueFluent<?> fluent,Int32Value instance){
            this(fluent, instance, true);
    }
    public Int32ValueBuilder(Int32ValueFluent<?> fluent,Int32Value instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public Int32ValueBuilder(Int32Value instance){
            this(instance,true);
    }
    public Int32ValueBuilder(Int32Value instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public Int32Value build(){
            Int32Value buildable = new Int32Value(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            Int32ValueBuilder that = (Int32ValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
