package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class IstioResourceListFluentImpl<A extends IstioResourceListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IstioResourceListFluent<A>{

    private String apiVersion;
    private List<IstioResource> items;
    private String kind;
    private ListMeta metadata;

    public IstioResourceListFluentImpl(){
    }
    public IstioResourceListFluentImpl(IstioResourceList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,IstioResource item){
            if (this.items == null) {this.items = new ArrayList<IstioResource>();}
            this.items.add(index, item);
            return (A)this;
    }

    public A setToItems(int index,IstioResource item){
            if (this.items == null) {this.items = new ArrayList<IstioResource>();}
            this.items.set(index, item); return (A)this;
    }

    public A addToItems(IstioResource... items){
            if (this.items == null) {this.items = new ArrayList<IstioResource>();}
            for (IstioResource item : items) {this.items.add(item);} return (A)this;
    }

    public A addAllToItems(Collection<IstioResource> items){
            if (this.items == null) {this.items = new ArrayList<IstioResource>();}
            for (IstioResource item : items) {this.items.add(item);} return (A)this;
    }

    public A removeFromItems(IstioResource... items){
            for (IstioResource item : items) {if (this.items!= null){ this.items.remove(item);}} return (A)this;
    }

    public A removeAllFromItems(Collection<IstioResource> items){
            for (IstioResource item : items) {if (this.items!= null){ this.items.remove(item);}} return (A)this;
    }

    public List<IstioResource> getItems(){
            return this.items;
    }

    public IstioResource getItem(int index){
            return this.items.get(index);
    }

    public IstioResource getFirstItem(){
            return this.items.get(0);
    }

    public IstioResource getLastItem(){
            return this.items.get(items.size() - 1);
    }

    public IstioResource getMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<IstioResource> predicate){
            for (IstioResource item: items) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<IstioResource> predicate){
            for (IstioResource item: items) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withItems(List<IstioResource> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<IstioResource>(); for (IstioResource item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(IstioResource... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (IstioResource item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            IstioResourceListFluentImpl that = (IstioResourceListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }




}
