
package me.snowdrop.istio.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "values"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ListValue implements Serializable
{

    /**
     * 
     */
    @JsonProperty("values")
    @JsonPropertyDescription("")
    private List<Value> values = new ArrayList<Value>();
    private final static long serialVersionUID = -2102508629375545693L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ListValue() {
    }

    /**
     * 
     * @param values
     */
    public ListValue(List<Value> values) {
        super();
        this.values = values;
    }

    /**
     * 
     */
    public List<Value> getValues() {
        return values;
    }

    /**
     * 
     */
    public void setValues(List<Value> values) {
        this.values = values;
    }

}
