package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ListValueBuilder extends ListValueFluentImpl<ListValueBuilder> implements VisitableBuilder<ListValue,ListValueBuilder>{

    ListValueFluent<?> fluent;
    Boolean validationEnabled;

    public ListValueBuilder(){
            this(true);
    }
    public ListValueBuilder(Boolean validationEnabled){
            this(new ListValue(), validationEnabled);
    }
    public ListValueBuilder(ListValueFluent<?> fluent){
            this(fluent, true);
    }
    public ListValueBuilder(ListValueFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListValue(), validationEnabled);
    }
    public ListValueBuilder(ListValueFluent<?> fluent,ListValue instance){
            this(fluent, instance, true);
    }
    public ListValueBuilder(ListValueFluent<?> fluent,ListValue instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListValueBuilder(ListValue instance){
            this(instance,true);
    }
    public ListValueBuilder(ListValue instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValues(instance.getValues()); 
            this.validationEnabled = validationEnabled; 
    }

    public ListValue build(){
            ListValue buildable = new ListValue(fluent.getValues());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListValueBuilder that = (ListValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
