package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ListValueFluentImpl<A extends ListValueFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ListValueFluent<A>{

    private List<ValueBuilder> values;

    public ListValueFluentImpl(){
    }
    public ListValueFluentImpl(ListValue instance){
            this.withValues(instance.getValues()); 
    }

    public A addToValues(int index,me.snowdrop.istio.api.Value item){
            if (this.values == null) {this.values = new ArrayList<ValueBuilder>();}
            me.snowdrop.istio.api.ValueBuilder builder = new me.snowdrop.istio.api.ValueBuilder(item);_visitables.get("values").add(index >= 0 ? index : _visitables.get("values").size(), builder);this.values.add(index >= 0 ? index : values.size(), builder); return (A)this;
    }

    public A setToValues(int index,me.snowdrop.istio.api.Value item){
            if (this.values == null) {this.values = new ArrayList<ValueBuilder>();}
            me.snowdrop.istio.api.ValueBuilder builder = new me.snowdrop.istio.api.ValueBuilder(item);
            if (index < 0 || index >= _visitables.get("values").size()) { _visitables.get("values").add(builder); } else { _visitables.get("values").set(index, builder);}
            if (index < 0 || index >= values.size()) { values.add(builder); } else { values.set(index, builder);}
             return (A)this;
    }

    public A addToValues(me.snowdrop.istio.api.Value... items){
            if (this.values == null) {this.values = new ArrayList<ValueBuilder>();}
            for (me.snowdrop.istio.api.Value item : items) {me.snowdrop.istio.api.ValueBuilder builder = new me.snowdrop.istio.api.ValueBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
    }

    public A addAllToValues(Collection<me.snowdrop.istio.api.Value> items){
            if (this.values == null) {this.values = new ArrayList<ValueBuilder>();}
            for (me.snowdrop.istio.api.Value item : items) {me.snowdrop.istio.api.ValueBuilder builder = new me.snowdrop.istio.api.ValueBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
    }

    public A removeFromValues(me.snowdrop.istio.api.Value... items){
            for (me.snowdrop.istio.api.Value item : items) {me.snowdrop.istio.api.ValueBuilder builder = new me.snowdrop.istio.api.ValueBuilder(item);_visitables.get("values").remove(builder);if (this.values != null) {this.values.remove(builder);}} return (A)this;
    }

    public A removeAllFromValues(Collection<me.snowdrop.istio.api.Value> items){
            for (me.snowdrop.istio.api.Value item : items) {me.snowdrop.istio.api.ValueBuilder builder = new me.snowdrop.istio.api.ValueBuilder(item);_visitables.get("values").remove(builder);if (this.values != null) {this.values.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromValues(io.fabric8.kubernetes.api.builder.Predicate<ValueBuilder> predicate){
            if (values == null) return (A) this;
            final Iterator<ValueBuilder> each = values.iterator();
            final List visitables = _visitables.get("values");
            while (each.hasNext()) {
              ValueBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildValues instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.Value> getValues(){
            return build(values);
    }

    public List<me.snowdrop.istio.api.Value> buildValues(){
            return build(values);
    }

    public me.snowdrop.istio.api.Value buildValue(int index){
            return this.values.get(index).build();
    }

    public me.snowdrop.istio.api.Value buildFirstValue(){
            return this.values.get(0).build();
    }

    public me.snowdrop.istio.api.Value buildLastValue(){
            return this.values.get(values.size() - 1).build();
    }

    public me.snowdrop.istio.api.Value buildMatchingValue(io.fabric8.kubernetes.api.builder.Predicate<ValueBuilder> predicate){
            for (ValueBuilder item: values) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingValue(io.fabric8.kubernetes.api.builder.Predicate<ValueBuilder> predicate){
            for (ValueBuilder item: values) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withValues(List<me.snowdrop.istio.api.Value> values){
            if (this.values != null) { _visitables.get("values").removeAll(this.values);}
            if (values != null) {this.values = new ArrayList<ValueBuilder>(); for (me.snowdrop.istio.api.Value item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
    }

    public A withValues(me.snowdrop.istio.api.Value... values){
            if (this.values != null) {this.values.clear();}
            if (values != null) {for (me.snowdrop.istio.api.Value item :values){ this.addToValues(item);}} return (A) this;
    }

    public Boolean hasValues(){
            return values != null && !values.isEmpty();
    }

    public ListValueFluent.ValuesNested<A> addNewValue(){
            return new ValuesNestedImpl();
    }

    public ListValueFluent.ValuesNested<A> addNewValueLike(me.snowdrop.istio.api.Value item){
            return new ValuesNestedImpl(-1, item);
    }

    public ListValueFluent.ValuesNested<A> setNewValueLike(int index,me.snowdrop.istio.api.Value item){
            return new ValuesNestedImpl(index, item);
    }

    public ListValueFluent.ValuesNested<A> editValue(int index){
            if (values.size() <= index) throw new RuntimeException("Can't edit values. Index exceeds size.");
            return setNewValueLike(index, buildValue(index));
    }

    public ListValueFluent.ValuesNested<A> editFirstValue(){
            if (values.size() == 0) throw new RuntimeException("Can't edit first values. The list is empty.");
            return setNewValueLike(0, buildValue(0));
    }

    public ListValueFluent.ValuesNested<A> editLastValue(){
            int index = values.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last values. The list is empty.");
            return setNewValueLike(index, buildValue(index));
    }

    public ListValueFluent.ValuesNested<A> editMatchingValue(io.fabric8.kubernetes.api.builder.Predicate<ValueBuilder> predicate){
            int index = -1;
            for (int i=0;i<values.size();i++) { 
            if (predicate.apply(values.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching values. No match found.");
            return setNewValueLike(index, buildValue(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ListValueFluentImpl that = (ListValueFluentImpl) o;
            if (values != null ? !values.equals(that.values) :that.values != null) return false;
            return true;
    }


    public class ValuesNestedImpl<N> extends ValueFluentImpl<ListValueFluent.ValuesNested<N>> implements ListValueFluent.ValuesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ValueBuilder builder;
        private final int index;
    
            ValuesNestedImpl(int index,me.snowdrop.istio.api.Value item){
                    this.index = index;
                    this.builder = new ValueBuilder(this, item);
            }
            ValuesNestedImpl(){
                    this.index = -1;
                    this.builder = new ValueBuilder(this);
            }
    
    public N and(){
            return (N) ListValueFluentImpl.this.setToValues(index,builder.build());
    }
    public N endValue(){
            return and();
    }

}


}
