
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Value.Kind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "listValue"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ListValueKind implements Serializable, Kind
{

    /**
     * 
     */
    @JsonProperty("listValue")
    @JsonPropertyDescription("")
    private ListValue listValue;
    private final static long serialVersionUID = -8956863334167260121L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ListValueKind() {
    }

    /**
     * 
     * @param listValue
     */
    public ListValueKind(ListValue listValue) {
        super();
        this.listValue = listValue;
    }

    /**
     * 
     */
    public ListValue getListValue() {
        return listValue;
    }

    /**
     * 
     */
    public void setListValue(ListValue listValue) {
        this.listValue = listValue;
    }

}
