package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ListValueKindBuilder extends ListValueKindFluentImpl<ListValueKindBuilder> implements VisitableBuilder<ListValueKind,ListValueKindBuilder>{

    ListValueKindFluent<?> fluent;
    Boolean validationEnabled;

    public ListValueKindBuilder(){
            this(true);
    }
    public ListValueKindBuilder(Boolean validationEnabled){
            this(new ListValueKind(), validationEnabled);
    }
    public ListValueKindBuilder(ListValueKindFluent<?> fluent){
            this(fluent, true);
    }
    public ListValueKindBuilder(ListValueKindFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ListValueKind(), validationEnabled);
    }
    public ListValueKindBuilder(ListValueKindFluent<?> fluent,ListValueKind instance){
            this(fluent, instance, true);
    }
    public ListValueKindBuilder(ListValueKindFluent<?> fluent,ListValueKind instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withListValue(instance.getListValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public ListValueKindBuilder(ListValueKind instance){
            this(instance,true);
    }
    public ListValueKindBuilder(ListValueKind instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withListValue(instance.getListValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public ListValueKind build(){
            ListValueKind buildable = new ListValueKind(fluent.getListValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListValueKindBuilder that = (ListValueKindBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
