
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Value.Kind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "nullValue"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class NullValueKind implements Serializable, Kind
{

    @JsonProperty("nullValue")
    private NullValue nullValue;
    private final static long serialVersionUID = 5924759349442787554L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public NullValueKind() {
    }

    /**
     * 
     * @param nullValue
     */
    public NullValueKind(NullValue nullValue) {
        super();
        this.nullValue = nullValue;
    }

    public NullValue getNullValue() {
        return nullValue;
    }

    public void setNullValue(NullValue nullValue) {
        this.nullValue = nullValue;
    }

}
