package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NullValueKindBuilder extends NullValueKindFluentImpl<NullValueKindBuilder> implements VisitableBuilder<NullValueKind,NullValueKindBuilder>{

    NullValueKindFluent<?> fluent;
    Boolean validationEnabled;

    public NullValueKindBuilder(){
            this(true);
    }
    public NullValueKindBuilder(Boolean validationEnabled){
            this(new NullValueKind(), validationEnabled);
    }
    public NullValueKindBuilder(NullValueKindFluent<?> fluent){
            this(fluent, true);
    }
    public NullValueKindBuilder(NullValueKindFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NullValueKind(), validationEnabled);
    }
    public NullValueKindBuilder(NullValueKindFluent<?> fluent,NullValueKind instance){
            this(fluent, instance, true);
    }
    public NullValueKindBuilder(NullValueKindFluent<?> fluent,NullValueKind instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNullValue(instance.getNullValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public NullValueKindBuilder(NullValueKind instance){
            this(instance,true);
    }
    public NullValueKindBuilder(NullValueKind instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNullValue(instance.getNullValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public NullValueKind build(){
            NullValueKind buildable = new NullValueKind(fluent.getNullValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NullValueKindBuilder that = (NullValueKindBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
