
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Value.Kind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "numberValue"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class NumberValueKind implements Serializable, Kind
{

    /**
     * 
     */
    @JsonProperty("numberValue")
    @JsonPropertyDescription("")
    private Double numberValue;
    private final static long serialVersionUID = 319140640381474577L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public NumberValueKind() {
    }

    /**
     * 
     * @param numberValue
     */
    public NumberValueKind(Double numberValue) {
        super();
        this.numberValue = numberValue;
    }

    /**
     * 
     */
    public Double getNumberValue() {
        return numberValue;
    }

    /**
     * 
     */
    public void setNumberValue(Double numberValue) {
        this.numberValue = numberValue;
    }

}
