package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NumberValueKindBuilder extends NumberValueKindFluentImpl<NumberValueKindBuilder> implements VisitableBuilder<NumberValueKind,NumberValueKindBuilder>{

    NumberValueKindFluent<?> fluent;
    Boolean validationEnabled;

    public NumberValueKindBuilder(){
            this(true);
    }
    public NumberValueKindBuilder(Boolean validationEnabled){
            this(new NumberValueKind(), validationEnabled);
    }
    public NumberValueKindBuilder(NumberValueKindFluent<?> fluent){
            this(fluent, true);
    }
    public NumberValueKindBuilder(NumberValueKindFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NumberValueKind(), validationEnabled);
    }
    public NumberValueKindBuilder(NumberValueKindFluent<?> fluent,NumberValueKind instance){
            this(fluent, instance, true);
    }
    public NumberValueKindBuilder(NumberValueKindFluent<?> fluent,NumberValueKind instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNumberValue(instance.getNumberValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public NumberValueKindBuilder(NumberValueKind instance){
            this(instance,true);
    }
    public NumberValueKindBuilder(NumberValueKind instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNumberValue(instance.getNumberValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public NumberValueKind build(){
            NumberValueKind buildable = new NumberValueKind(fluent.getNumberValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NumberValueKindBuilder that = (NumberValueKindBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
