
package me.snowdrop.istio.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "code",
    "details",
    "message"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Status implements Serializable
{

    /**
     * 
     */
    @JsonProperty("code")
    @JsonPropertyDescription("")
    private Integer code;
    /**
     * 
     */
    @JsonProperty("details")
    @JsonPropertyDescription("")
    private List<Any> details = new ArrayList<Any>();
    /**
     * 
     */
    @JsonProperty("message")
    @JsonPropertyDescription("")
    private String message;
    private final static long serialVersionUID = 2502375131099118332L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Status() {
    }

    /**
     * 
     * @param code
     * @param details
     * @param message
     */
    public Status(Integer code, List<Any> details, String message) {
        super();
        this.code = code;
        this.details = details;
        this.message = message;
    }

    /**
     * 
     */
    public Integer getCode() {
        return code;
    }

    /**
     * 
     */
    public void setCode(Integer code) {
        this.code = code;
    }

    /**
     * 
     */
    public List<Any> getDetails() {
        return details;
    }

    /**
     * 
     */
    public void setDetails(List<Any> details) {
        this.details = details;
    }

    /**
     * 
     */
    public String getMessage() {
        return message;
    }

    /**
     * 
     */
    public void setMessage(String message) {
        this.message = message;
    }

}
