package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class StatusFluentImpl<A extends StatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StatusFluent<A>{

    private Integer code;
    private List<AnyBuilder> details;
    private String message;

    public StatusFluentImpl(){
    }
    public StatusFluentImpl(Status instance){
            this.withCode(instance.getCode()); 
            this.withDetails(instance.getDetails()); 
            this.withMessage(instance.getMessage()); 
    }

    public Integer getCode(){
            return this.code;
    }

    public A withCode(Integer code){
            this.code=code; return (A) this;
    }

    public Boolean hasCode(){
            return this.code != null;
    }

    public A addToDetails(int index,Any item){
            if (this.details == null) {this.details = new ArrayList<AnyBuilder>();}
            AnyBuilder builder = new AnyBuilder(item);_visitables.get("details").add(index >= 0 ? index : _visitables.get("details").size(), builder);this.details.add(index >= 0 ? index : details.size(), builder); return (A)this;
    }

    public A setToDetails(int index,Any item){
            if (this.details == null) {this.details = new ArrayList<AnyBuilder>();}
            AnyBuilder builder = new AnyBuilder(item);
            if (index < 0 || index >= _visitables.get("details").size()) { _visitables.get("details").add(builder); } else { _visitables.get("details").set(index, builder);}
            if (index < 0 || index >= details.size()) { details.add(builder); } else { details.set(index, builder);}
             return (A)this;
    }

    public A addToDetails(Any... items){
            if (this.details == null) {this.details = new ArrayList<AnyBuilder>();}
            for (Any item : items) {AnyBuilder builder = new AnyBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
    }

    public A addAllToDetails(Collection<Any> items){
            if (this.details == null) {this.details = new ArrayList<AnyBuilder>();}
            for (Any item : items) {AnyBuilder builder = new AnyBuilder(item);_visitables.get("details").add(builder);this.details.add(builder);} return (A)this;
    }

    public A removeFromDetails(Any... items){
            for (Any item : items) {AnyBuilder builder = new AnyBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
    }

    public A removeAllFromDetails(Collection<Any> items){
            for (Any item : items) {AnyBuilder builder = new AnyBuilder(item);_visitables.get("details").remove(builder);if (this.details != null) {this.details.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDetails(io.fabric8.kubernetes.api.builder.Predicate<AnyBuilder> predicate){
            if (details == null) return (A) this;
            final Iterator<AnyBuilder> each = details.iterator();
            final List visitables = _visitables.get("details");
            while (each.hasNext()) {
              AnyBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDetails instead.
 * @return The buildable object.
 */
@Deprecated public List<Any> getDetails(){
            return build(details);
    }

    public List<Any> buildDetails(){
            return build(details);
    }

    public Any buildDetail(int index){
            return this.details.get(index).build();
    }

    public Any buildFirstDetail(){
            return this.details.get(0).build();
    }

    public Any buildLastDetail(){
            return this.details.get(details.size() - 1).build();
    }

    public Any buildMatchingDetail(io.fabric8.kubernetes.api.builder.Predicate<AnyBuilder> predicate){
            for (AnyBuilder item: details) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDetail(io.fabric8.kubernetes.api.builder.Predicate<AnyBuilder> predicate){
            for (AnyBuilder item: details) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDetails(List<Any> details){
            if (this.details != null) { _visitables.get("details").removeAll(this.details);}
            if (details != null) {this.details = new ArrayList<AnyBuilder>(); for (Any item : details){this.addToDetails(item);}} else { this.details = null;} return (A) this;
    }

    public A withDetails(Any... details){
            if (this.details != null) {this.details.clear();}
            if (details != null) {for (Any item :details){ this.addToDetails(item);}} return (A) this;
    }

    public Boolean hasDetails(){
            return details != null && !details.isEmpty();
    }

    public A addNewDetail(String typeUrl,String value){
            return (A)addToDetails(new Any(typeUrl, value));
    }

    public StatusFluent.DetailsNested<A> addNewDetail(){
            return new DetailsNestedImpl();
    }

    public StatusFluent.DetailsNested<A> addNewDetailLike(Any item){
            return new DetailsNestedImpl(-1, item);
    }

    public StatusFluent.DetailsNested<A> setNewDetailLike(int index,Any item){
            return new DetailsNestedImpl(index, item);
    }

    public StatusFluent.DetailsNested<A> editDetail(int index){
            if (details.size() <= index) throw new RuntimeException("Can't edit details. Index exceeds size.");
            return setNewDetailLike(index, buildDetail(index));
    }

    public StatusFluent.DetailsNested<A> editFirstDetail(){
            if (details.size() == 0) throw new RuntimeException("Can't edit first details. The list is empty.");
            return setNewDetailLike(0, buildDetail(0));
    }

    public StatusFluent.DetailsNested<A> editLastDetail(){
            int index = details.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last details. The list is empty.");
            return setNewDetailLike(index, buildDetail(index));
    }

    public StatusFluent.DetailsNested<A> editMatchingDetail(io.fabric8.kubernetes.api.builder.Predicate<AnyBuilder> predicate){
            int index = -1;
            for (int i=0;i<details.size();i++) { 
            if (predicate.apply(details.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching details. No match found.");
            return setNewDetailLike(index, buildDetail(index));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StatusFluentImpl that = (StatusFluentImpl) o;
            if (code != null ? !code.equals(that.code) :that.code != null) return false;
            if (details != null ? !details.equals(that.details) :that.details != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            return true;
    }


    public class DetailsNestedImpl<N> extends AnyFluentImpl<StatusFluent.DetailsNested<N>> implements StatusFluent.DetailsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AnyBuilder builder;
        private final int index;
    
            DetailsNestedImpl(int index,Any item){
                    this.index = index;
                    this.builder = new AnyBuilder(this, item);
            }
            DetailsNestedImpl(){
                    this.index = -1;
                    this.builder = new AnyBuilder(this);
            }
    
    public N and(){
            return (N) StatusFluentImpl.this.setToDetails(index,builder.build());
    }
    public N endDetail(){
            return and();
    }

}


}
