
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Value.Kind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "stringValue"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class StringValueKind implements Serializable, Kind
{

    /**
     * 
     */
    @JsonProperty("stringValue")
    @JsonPropertyDescription("")
    private String stringValue;
    private final static long serialVersionUID = 7674090543753797408L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StringValueKind() {
    }

    /**
     * 
     * @param stringValue
     */
    public StringValueKind(String stringValue) {
        super();
        this.stringValue = stringValue;
    }

    /**
     * 
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * 
     */
    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

}
