package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StringValueKindBuilder extends StringValueKindFluentImpl<StringValueKindBuilder> implements VisitableBuilder<StringValueKind,StringValueKindBuilder>{

    StringValueKindFluent<?> fluent;
    Boolean validationEnabled;

    public StringValueKindBuilder(){
            this(true);
    }
    public StringValueKindBuilder(Boolean validationEnabled){
            this(new StringValueKind(), validationEnabled);
    }
    public StringValueKindBuilder(StringValueKindFluent<?> fluent){
            this(fluent, true);
    }
    public StringValueKindBuilder(StringValueKindFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StringValueKind(), validationEnabled);
    }
    public StringValueKindBuilder(StringValueKindFluent<?> fluent,StringValueKind instance){
            this(fluent, instance, true);
    }
    public StringValueKindBuilder(StringValueKindFluent<?> fluent,StringValueKind instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStringValue(instance.getStringValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public StringValueKindBuilder(StringValueKind instance){
            this(instance,true);
    }
    public StringValueKindBuilder(StringValueKind instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStringValue(instance.getStringValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public StringValueKind build(){
            StringValueKind buildable = new StringValueKind(fluent.getStringValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StringValueKindBuilder that = (StringValueKindBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
