package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class StringValueKindFluentImpl<A extends StringValueKindFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StringValueKindFluent<A>{

    private String stringValue;

    public StringValueKindFluentImpl(){
    }
    public StringValueKindFluentImpl(StringValueKind instance){
            this.withStringValue(instance.getStringValue()); 
    }

    public String getStringValue(){
            return this.stringValue;
    }

    public A withStringValue(String stringValue){
            this.stringValue=stringValue; return (A) this;
    }

    public Boolean hasStringValue(){
            return this.stringValue != null;
    }

    public A withNewStringValue(String arg1){
            return (A)withStringValue(new String(arg1));
    }

    public A withNewStringValue(StringBuilder arg1){
            return (A)withStringValue(new String(arg1));
    }

    public A withNewStringValue(StringBuffer arg1){
            return (A)withStringValue(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StringValueKindFluentImpl that = (StringValueKindFluentImpl) o;
            if (stringValue != null ? !stringValue.equals(that.stringValue) :that.stringValue != null) return false;
            return true;
    }




}
