
package me.snowdrop.istio.api;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Value.Kind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "structValue"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class StructValueKind implements Serializable, Kind
{

    @JsonProperty("structValue")
    private Map<String, Object> structValue;
    private final static long serialVersionUID = -2976361354296448959L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StructValueKind() {
    }

    /**
     * 
     * @param structValue
     */
    public StructValueKind(Map<String, Object> structValue) {
        super();
        this.structValue = structValue;
    }

    public Map<String, Object> getStructValue() {
        return structValue;
    }

    public void setStructValue(Map<String, Object> structValue) {
        this.structValue = structValue;
    }

}
