package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StructValueKindBuilder extends StructValueKindFluentImpl<StructValueKindBuilder> implements VisitableBuilder<StructValueKind,StructValueKindBuilder>{

    StructValueKindFluent<?> fluent;
    Boolean validationEnabled;

    public StructValueKindBuilder(){
            this(true);
    }
    public StructValueKindBuilder(Boolean validationEnabled){
            this(new StructValueKind(), validationEnabled);
    }
    public StructValueKindBuilder(StructValueKindFluent<?> fluent){
            this(fluent, true);
    }
    public StructValueKindBuilder(StructValueKindFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StructValueKind(), validationEnabled);
    }
    public StructValueKindBuilder(StructValueKindFluent<?> fluent,StructValueKind instance){
            this(fluent, instance, true);
    }
    public StructValueKindBuilder(StructValueKindFluent<?> fluent,StructValueKind instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStructValue(instance.getStructValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public StructValueKindBuilder(StructValueKind instance){
            this(instance,true);
    }
    public StructValueKindBuilder(StructValueKind instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStructValue(instance.getStructValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public StructValueKind build(){
            StructValueKind buildable = new StructValueKind(fluent.getStructValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StructValueKindBuilder that = (StructValueKindBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
