package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class StructValueKindFluentImpl<A extends StructValueKindFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StructValueKindFluent<A>{

    private Map<String,Object> structValue;

    public StructValueKindFluentImpl(){
    }
    public StructValueKindFluentImpl(StructValueKind instance){
            this.withStructValue(instance.getStructValue()); 
    }

    public A addToStructValue(String key,Object value){
            if(this.structValue == null && key != null && value != null) { this.structValue = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.structValue.put(key, value);} return (A)this;
    }

    public A addToStructValue(Map<String,Object> map){
            if(this.structValue == null && map != null) { this.structValue = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.structValue.putAll(map);} return (A)this;
    }

    public A removeFromStructValue(String key){
            if(this.structValue == null) { return (A) this; }
            if(key != null && this.structValue != null) {this.structValue.remove(key);} return (A)this;
    }

    public A removeFromStructValue(Map<String,Object> map){
            if(this.structValue == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.structValue != null){this.structValue.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getStructValue(){
            return this.structValue;
    }

    public A withStructValue(Map<String,Object> structValue){
            if (structValue == null) { this.structValue =  null;} else {this.structValue = new LinkedHashMap<String,Object>(structValue);} return (A) this;
    }

    public Boolean hasStructValue(){
            return this.structValue != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StructValueKindFluentImpl that = (StructValueKindFluentImpl) o;
            if (structValue != null ? !structValue.equals(that.structValue) :that.structValue != null) return false;
            return true;
    }




}
