
package me.snowdrop.istio.api;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Value implements Serializable
{

    @JsonProperty("kind")
    @JsonUnwrapped
    private me.snowdrop.istio.api.Value.Kind kind;
    private final static long serialVersionUID = -702077089919096981L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Value() {
    }

    /**
     * 
     * @param kind
     */
    public Value(me.snowdrop.istio.api.Value.Kind kind) {
        super();
        this.kind = kind;
    }

    public me.snowdrop.istio.api.Value.Kind getKind() {
        return kind;
    }

    public void setKind(me.snowdrop.istio.api.Value.Kind kind) {
        this.kind = kind;
    }

    public interface Kind extends Serializable
    {


    }

}
