package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ValueBuilder extends ValueFluentImpl<ValueBuilder> implements VisitableBuilder<me.snowdrop.istio.api.Value,ValueBuilder>{

    ValueFluent<?> fluent;
    Boolean validationEnabled;

    public ValueBuilder(){
            this(true);
    }
    public ValueBuilder(Boolean validationEnabled){
            this(new Value(), validationEnabled);
    }
    public ValueBuilder(ValueFluent<?> fluent){
            this(fluent, true);
    }
    public ValueBuilder(ValueFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Value(), validationEnabled);
    }
    public ValueBuilder(ValueFluent<?> fluent,me.snowdrop.istio.api.Value instance){
            this(fluent, instance, true);
    }
    public ValueBuilder(ValueFluent<?> fluent,me.snowdrop.istio.api.Value instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKind(instance.getKind()); 
            this.validationEnabled = validationEnabled; 
    }
    public ValueBuilder(me.snowdrop.istio.api.Value instance){
            this(instance,true);
    }
    public ValueBuilder(me.snowdrop.istio.api.Value instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKind(instance.getKind()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.Value build(){
            Value buildable = new Value(fluent.getKind());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ValueBuilder that = (ValueBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
