package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;

public class ValueFluentImpl<A extends ValueFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ValueFluent<A>{

    private VisitableBuilder<? extends Value.Kind,?> kind;

    public ValueFluentImpl(){
    }
    public ValueFluentImpl(me.snowdrop.istio.api.Value instance){
            this.withKind(instance.getKind()); 
    }

    
/**
 * This method has been deprecated, please use method buildKind instead.
 * @return The buildable object.
 */
@Deprecated public Value.Kind getKind(){
            return this.kind!=null?this.kind.build():null;
    }

    public Value.Kind buildKind(){
            return this.kind!=null?this.kind.build():null;
    }

    public A withKind(Value.Kind kind){
            if (kind instanceof NumberValueKind){ this.kind= new NumberValueKindBuilder((NumberValueKind)kind); _visitables.get("kind").add(this.kind);}
            if (kind instanceof StructValueKind){ this.kind= new StructValueKindBuilder((StructValueKind)kind); _visitables.get("kind").add(this.kind);}
            if (kind instanceof NullValueKind){ this.kind= new NullValueKindBuilder((NullValueKind)kind); _visitables.get("kind").add(this.kind);}
            if (kind instanceof StringValueKind){ this.kind= new StringValueKindBuilder((StringValueKind)kind); _visitables.get("kind").add(this.kind);}
            if (kind instanceof ListValueKind){ this.kind= new ListValueKindBuilder((ListValueKind)kind); _visitables.get("kind").add(this.kind);}
            if (kind instanceof BoolValueKind){ this.kind= new BoolValueKindBuilder((BoolValueKind)kind); _visitables.get("kind").add(this.kind);}
            return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNumberValueKind(NumberValueKind numberValueKind){
            _visitables.get("kind").remove(this.kind);
            if (numberValueKind!=null){ this.kind= new NumberValueKindBuilder(numberValueKind); _visitables.get("kind").add(this.kind);} return (A) this;
    }

    public ValueFluent.NumberValueKindNested<A> withNewNumberValueKind(){
            return new NumberValueKindNestedImpl();
    }

    public ValueFluent.NumberValueKindNested<A> withNewNumberValueKindLike(NumberValueKind item){
            return new NumberValueKindNestedImpl(item);
    }

    public A withNewNumberValueKind(Double numberValue){
            return (A)withNumberValueKind(new NumberValueKind(numberValue));
    }

    public A withStructValueKind(StructValueKind structValueKind){
            _visitables.get("kind").remove(this.kind);
            if (structValueKind!=null){ this.kind= new StructValueKindBuilder(structValueKind); _visitables.get("kind").add(this.kind);} return (A) this;
    }

    public ValueFluent.StructValueKindNested<A> withNewStructValueKind(){
            return new StructValueKindNestedImpl();
    }

    public ValueFluent.StructValueKindNested<A> withNewStructValueKindLike(StructValueKind item){
            return new StructValueKindNestedImpl(item);
    }

    public A withNullValueKind(NullValueKind nullValueKind){
            _visitables.get("kind").remove(this.kind);
            if (nullValueKind!=null){ this.kind= new NullValueKindBuilder(nullValueKind); _visitables.get("kind").add(this.kind);} return (A) this;
    }

    public ValueFluent.NullValueKindNested<A> withNewNullValueKind(){
            return new NullValueKindNestedImpl();
    }

    public ValueFluent.NullValueKindNested<A> withNewNullValueKindLike(NullValueKind item){
            return new NullValueKindNestedImpl(item);
    }

    public A withStringValueKind(StringValueKind stringValueKind){
            _visitables.get("kind").remove(this.kind);
            if (stringValueKind!=null){ this.kind= new StringValueKindBuilder(stringValueKind); _visitables.get("kind").add(this.kind);} return (A) this;
    }

    public ValueFluent.StringValueKindNested<A> withNewStringValueKind(){
            return new StringValueKindNestedImpl();
    }

    public ValueFluent.StringValueKindNested<A> withNewStringValueKindLike(StringValueKind item){
            return new StringValueKindNestedImpl(item);
    }

    public A withNewStringValueKind(String stringValue){
            return (A)withStringValueKind(new StringValueKind(stringValue));
    }

    public A withListValueKind(ListValueKind listValueKind){
            _visitables.get("kind").remove(this.kind);
            if (listValueKind!=null){ this.kind= new ListValueKindBuilder(listValueKind); _visitables.get("kind").add(this.kind);} return (A) this;
    }

    public ValueFluent.ListValueKindNested<A> withNewListValueKind(){
            return new ListValueKindNestedImpl();
    }

    public ValueFluent.ListValueKindNested<A> withNewListValueKindLike(ListValueKind item){
            return new ListValueKindNestedImpl(item);
    }

    public A withBoolValueKind(BoolValueKind boolValueKind){
            _visitables.get("kind").remove(this.kind);
            if (boolValueKind!=null){ this.kind= new BoolValueKindBuilder(boolValueKind); _visitables.get("kind").add(this.kind);} return (A) this;
    }

    public ValueFluent.BoolValueKindNested<A> withNewBoolValueKind(){
            return new BoolValueKindNestedImpl();
    }

    public ValueFluent.BoolValueKindNested<A> withNewBoolValueKindLike(BoolValueKind item){
            return new BoolValueKindNestedImpl(item);
    }

    public A withNewBoolValueKind(Boolean boolValue){
            return (A)withBoolValueKind(new BoolValueKind(boolValue));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ValueFluentImpl that = (ValueFluentImpl) o;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            return true;
    }


    public class NumberValueKindNestedImpl<N> extends NumberValueKindFluentImpl<ValueFluent.NumberValueKindNested<N>> implements ValueFluent.NumberValueKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NumberValueKindBuilder builder;
    
            NumberValueKindNestedImpl(NumberValueKind item){
                    this.builder = new NumberValueKindBuilder(this, item);
            }
            NumberValueKindNestedImpl(){
                    this.builder = new NumberValueKindBuilder(this);
            }
    
    public N and(){
            return (N) ValueFluentImpl.this.withKind(builder.build());
    }
    public N endNumberValueKind(){
            return and();
    }

}
    public class StructValueKindNestedImpl<N> extends StructValueKindFluentImpl<ValueFluent.StructValueKindNested<N>> implements ValueFluent.StructValueKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StructValueKindBuilder builder;
    
            StructValueKindNestedImpl(StructValueKind item){
                    this.builder = new StructValueKindBuilder(this, item);
            }
            StructValueKindNestedImpl(){
                    this.builder = new StructValueKindBuilder(this);
            }
    
    public N and(){
            return (N) ValueFluentImpl.this.withKind(builder.build());
    }
    public N endStructValueKind(){
            return and();
    }

}
    public class NullValueKindNestedImpl<N> extends NullValueKindFluentImpl<ValueFluent.NullValueKindNested<N>> implements ValueFluent.NullValueKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NullValueKindBuilder builder;
    
            NullValueKindNestedImpl(NullValueKind item){
                    this.builder = new NullValueKindBuilder(this, item);
            }
            NullValueKindNestedImpl(){
                    this.builder = new NullValueKindBuilder(this);
            }
    
    public N and(){
            return (N) ValueFluentImpl.this.withKind(builder.build());
    }
    public N endNullValueKind(){
            return and();
    }

}
    public class StringValueKindNestedImpl<N> extends StringValueKindFluentImpl<ValueFluent.StringValueKindNested<N>> implements ValueFluent.StringValueKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StringValueKindBuilder builder;
    
            StringValueKindNestedImpl(StringValueKind item){
                    this.builder = new StringValueKindBuilder(this, item);
            }
            StringValueKindNestedImpl(){
                    this.builder = new StringValueKindBuilder(this);
            }
    
    public N and(){
            return (N) ValueFluentImpl.this.withKind(builder.build());
    }
    public N endStringValueKind(){
            return and();
    }

}
    public class ListValueKindNestedImpl<N> extends ListValueKindFluentImpl<ValueFluent.ListValueKindNested<N>> implements ValueFluent.ListValueKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ListValueKindBuilder builder;
    
            ListValueKindNestedImpl(ListValueKind item){
                    this.builder = new ListValueKindBuilder(this, item);
            }
            ListValueKindNestedImpl(){
                    this.builder = new ListValueKindBuilder(this);
            }
    
    public N and(){
            return (N) ValueFluentImpl.this.withKind(builder.build());
    }
    public N endListValueKind(){
            return and();
    }

}
    public class BoolValueKindNestedImpl<N> extends BoolValueKindFluentImpl<ValueFluent.BoolValueKindNested<N>> implements ValueFluent.BoolValueKindNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BoolValueKindBuilder builder;
    
            BoolValueKindNestedImpl(BoolValueKind item){
                    this.builder = new BoolValueKindBuilder(this, item);
            }
            BoolValueKindNestedImpl(){
                    this.builder = new BoolValueKindBuilder(this);
            }
    
    public N and(){
            return (N) ValueFluentImpl.this.withKind(builder.build());
    }
    public N endBoolValueKind(){
            return and();
    }

}


}
