package me.snowdrop.istio.api.cexl;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import me.snowdrop.istio.api.mixer.config.descriptor.ValueType;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class TypedValueFluentImpl<A extends TypedValueFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TypedValueFluent<A>{

    private ValueType type;
    private String expression;

    public TypedValueFluentImpl(){
    }
    public TypedValueFluentImpl(TypedValue instance){
            this.withType(instance.getType()); 
            this.withExpression(instance.getExpression()); 
    }

    public ValueType getType(){
            return this.type;
    }

    public A withType(ValueType type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public String getExpression(){
            return this.expression;
    }

    public A withExpression(String expression){
            this.expression=expression; return (A) this;
    }

    public Boolean hasExpression(){
            return this.expression != null;
    }

    public A withNewExpression(String arg1){
            return (A)withExpression(new String(arg1));
    }

    public A withNewExpression(StringBuilder arg1){
            return (A)withExpression(new String(arg1));
    }

    public A withNewExpression(StringBuffer arg1){
            return (A)withExpression(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TypedValueFluentImpl that = (TypedValueFluentImpl) o;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            if (expression != null ? !expression.equals(that.expression) :that.expression != null) return false;
            return true;
    }




}
