
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "dnsNames",
    "secretName"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Certificate implements Serializable
{

    /**
     * 
     */
    @JsonProperty("dnsNames")
    @JsonPropertyDescription("")
    private List<String> dnsNames = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("secretName")
    @JsonPropertyDescription("")
    private String secretName;
    private final static long serialVersionUID = 8598232026040242084L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Certificate() {
    }

    /**
     * 
     * @param secretName
     * @param dnsNames
     */
    public Certificate(List<String> dnsNames, String secretName) {
        super();
        this.dnsNames = dnsNames;
        this.secretName = secretName;
    }

    /**
     * 
     */
    public List<String> getDnsNames() {
        return dnsNames;
    }

    /**
     * 
     */
    public void setDnsNames(List<String> dnsNames) {
        this.dnsNames = dnsNames;
    }

    /**
     * 
     */
    public String getSecretName() {
        return secretName;
    }

    /**
     * 
     */
    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

}
