package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CertificateBuilder extends CertificateFluentImpl<CertificateBuilder> implements VisitableBuilder<Certificate,CertificateBuilder>{

    CertificateFluent<?> fluent;
    Boolean validationEnabled;

    public CertificateBuilder(){
            this(true);
    }
    public CertificateBuilder(Boolean validationEnabled){
            this(new Certificate(), validationEnabled);
    }
    public CertificateBuilder(CertificateFluent<?> fluent){
            this(fluent, true);
    }
    public CertificateBuilder(CertificateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Certificate(), validationEnabled);
    }
    public CertificateBuilder(CertificateFluent<?> fluent,Certificate instance){
            this(fluent, instance, true);
    }
    public CertificateBuilder(CertificateFluent<?> fluent,Certificate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDnsNames(instance.getDnsNames()); 
            fluent.withSecretName(instance.getSecretName()); 
            this.validationEnabled = validationEnabled; 
    }
    public CertificateBuilder(Certificate instance){
            this(instance,true);
    }
    public CertificateBuilder(Certificate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDnsNames(instance.getDnsNames()); 
            this.withSecretName(instance.getSecretName()); 
            this.validationEnabled = validationEnabled; 
    }

    public Certificate build(){
            Certificate buildable = new Certificate(fluent.getDnsNames(),fluent.getSecretName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CertificateBuilder that = (CertificateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
