package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CertificateFluentImpl<A extends CertificateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CertificateFluent<A>{

    private List<String> dnsNames;
    private String secretName;

    public CertificateFluentImpl(){
    }
    public CertificateFluentImpl(Certificate instance){
            this.withDnsNames(instance.getDnsNames()); 
            this.withSecretName(instance.getSecretName()); 
    }

    public A addToDnsNames(int index,String item){
            if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
            this.dnsNames.add(index, item);
            return (A)this;
    }

    public A setToDnsNames(int index,String item){
            if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
            this.dnsNames.set(index, item); return (A)this;
    }

    public A addToDnsNames(String... items){
            if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
            for (String item : items) {this.dnsNames.add(item);} return (A)this;
    }

    public A addAllToDnsNames(Collection<String> items){
            if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
            for (String item : items) {this.dnsNames.add(item);} return (A)this;
    }

    public A removeFromDnsNames(String... items){
            for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
    }

    public A removeAllFromDnsNames(Collection<String> items){
            for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
    }

    public List<String> getDnsNames(){
            return this.dnsNames;
    }

    public String getDnsName(int index){
            return this.dnsNames.get(index);
    }

    public String getFirstDnsName(){
            return this.dnsNames.get(0);
    }

    public String getLastDnsName(){
            return this.dnsNames.get(dnsNames.size() - 1);
    }

    public String getMatchingDnsName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: dnsNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDnsName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: dnsNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDnsNames(List<String> dnsNames){
            if (this.dnsNames != null) { _visitables.get("dnsNames").removeAll(this.dnsNames);}
            if (dnsNames != null) {this.dnsNames = new ArrayList<String>(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
    }

    public A withDnsNames(String... dnsNames){
            if (this.dnsNames != null) {this.dnsNames.clear();}
            if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
    }

    public Boolean hasDnsNames(){
            return dnsNames != null && !dnsNames.isEmpty();
    }

    public A addNewDnsName(String arg1){
            return (A)addToDnsNames(new String(arg1));
    }

    public A addNewDnsName(StringBuilder arg1){
            return (A)addToDnsNames(new String(arg1));
    }

    public A addNewDnsName(StringBuffer arg1){
            return (A)addToDnsNames(new String(arg1));
    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public Boolean hasSecretName(){
            return this.secretName != null;
    }

    public A withNewSecretName(String arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuilder arg1){
            return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuffer arg1){
            return (A)withSecretName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CertificateFluentImpl that = (CertificateFluentImpl) o;
            if (dnsNames != null ? !dnsNames.equals(that.dnsNames) :that.dnsNames != null) return false;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            return true;
    }




}
