
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "subscribedResources",
    "tlsSettings"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ConfigSource implements Serializable
{

    /**
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private String address;
    @JsonProperty("subscribedResources")
    private Resource subscribedResources;
    /**
     * 
     */
    @JsonProperty("tlsSettings")
    @JsonPropertyDescription("")
    private ClientTLSSettings tlsSettings;
    private final static long serialVersionUID = -3182541699761709023L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConfigSource() {
    }

    /**
     * 
     * @param subscribedResources
     * @param address
     * @param tlsSettings
     */
    public ConfigSource(String address, Resource subscribedResources, ClientTLSSettings tlsSettings) {
        super();
        this.address = address;
        this.subscribedResources = subscribedResources;
        this.tlsSettings = tlsSettings;
    }

    /**
     * 
     */
    public String getAddress() {
        return address;
    }

    /**
     * 
     */
    public void setAddress(String address) {
        this.address = address;
    }

    public Resource getSubscribedResources() {
        return subscribedResources;
    }

    public void setSubscribedResources(Resource subscribedResources) {
        this.subscribedResources = subscribedResources;
    }

    /**
     * 
     */
    public ClientTLSSettings getTlsSettings() {
        return tlsSettings;
    }

    /**
     * 
     */
    public void setTlsSettings(ClientTLSSettings tlsSettings) {
        this.tlsSettings = tlsSettings;
    }

}
