package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;

public interface ConfigSourceFluent<A extends ConfigSourceFluent<A>> extends Fluent<A>{


    public String getAddress();
    public A withAddress(String address);
    public Boolean hasAddress();
    public A withNewAddress(String arg1);
    public A withNewAddress(StringBuilder arg1);
    public A withNewAddress(StringBuffer arg1);
    public Resource getSubscribedResources();
    public A withSubscribedResources(Resource subscribedResources);
    public Boolean hasSubscribedResources();
    
/**
 * This method has been deprecated, please use method buildTlsSettings instead.
 * @return The buildable object.
 */
@Deprecated public ClientTLSSettings getTlsSettings();
    public ClientTLSSettings buildTlsSettings();
    public A withTlsSettings(ClientTLSSettings tlsSettings);
    public Boolean hasTlsSettings();
    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettings();
    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettingsLike(ClientTLSSettings item);
    public ConfigSourceFluent.TlsSettingsNested<A> editTlsSettings();
    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettings();
    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(ClientTLSSettings item);

    public interface TlsSettingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClientTLSSettingsFluent<ConfigSourceFluent.TlsSettingsNested<N>>{

        
    public N and();    public N endTlsSettings();
}


}
