package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettings;
import me.snowdrop.istio.api.networking.v1alpha3.ClientTLSSettingsFluentImpl;

public class ConfigSourceFluentImpl<A extends ConfigSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConfigSourceFluent<A>{

    private String address;
    private Resource subscribedResources;
    private ClientTLSSettingsBuilder tlsSettings;

    public ConfigSourceFluentImpl(){
    }
    public ConfigSourceFluentImpl(ConfigSource instance){
            this.withAddress(instance.getAddress()); 
            this.withSubscribedResources(instance.getSubscribedResources()); 
            this.withTlsSettings(instance.getTlsSettings()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    public Resource getSubscribedResources(){
            return this.subscribedResources;
    }

    public A withSubscribedResources(Resource subscribedResources){
            this.subscribedResources=subscribedResources; return (A) this;
    }

    public Boolean hasSubscribedResources(){
            return this.subscribedResources != null;
    }

    
/**
 * This method has been deprecated, please use method buildTlsSettings instead.
 * @return The buildable object.
 */
@Deprecated public ClientTLSSettings getTlsSettings(){
            return this.tlsSettings!=null?this.tlsSettings.build():null;
    }

    public ClientTLSSettings buildTlsSettings(){
            return this.tlsSettings!=null?this.tlsSettings.build():null;
    }

    public A withTlsSettings(ClientTLSSettings tlsSettings){
            _visitables.get("tlsSettings").remove(this.tlsSettings);
            if (tlsSettings!=null){ this.tlsSettings= new ClientTLSSettingsBuilder(tlsSettings); _visitables.get("tlsSettings").add(this.tlsSettings);} return (A) this;
    }

    public Boolean hasTlsSettings(){
            return this.tlsSettings != null;
    }

    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettings(){
            return new TlsSettingsNestedImpl();
    }

    public ConfigSourceFluent.TlsSettingsNested<A> withNewTlsSettingsLike(ClientTLSSettings item){
            return new TlsSettingsNestedImpl(item);
    }

    public ConfigSourceFluent.TlsSettingsNested<A> editTlsSettings(){
            return withNewTlsSettingsLike(getTlsSettings());
    }

    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettings(){
            return withNewTlsSettingsLike(getTlsSettings() != null ? getTlsSettings(): new ClientTLSSettingsBuilder().build());
    }

    public ConfigSourceFluent.TlsSettingsNested<A> editOrNewTlsSettingsLike(ClientTLSSettings item){
            return withNewTlsSettingsLike(getTlsSettings() != null ? getTlsSettings(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ConfigSourceFluentImpl that = (ConfigSourceFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (subscribedResources != null ? !subscribedResources.equals(that.subscribedResources) :that.subscribedResources != null) return false;
            if (tlsSettings != null ? !tlsSettings.equals(that.tlsSettings) :that.tlsSettings != null) return false;
            return true;
    }


    public class TlsSettingsNestedImpl<N> extends ClientTLSSettingsFluentImpl<ConfigSourceFluent.TlsSettingsNested<N>> implements ConfigSourceFluent.TlsSettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClientTLSSettingsBuilder builder;
    
            TlsSettingsNestedImpl(ClientTLSSettings item){
                    this.builder = new ClientTLSSettingsBuilder(this, item);
            }
            TlsSettingsNestedImpl(){
                    this.builder = new ClientTLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) ConfigSourceFluentImpl.this.withTlsSettings(builder.build());
    }
    public N endTlsSettings(){
            return and();
    }

}


}
