
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "type"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class CustomTag implements Serializable
{

    @JsonProperty("type")
    @JsonUnwrapped
    private me.snowdrop.istio.api.mesh.v1alpha1.CustomTag.Type type;
    private final static long serialVersionUID = -4959572692661659393L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public CustomTag() {
    }

    /**
     * 
     * @param type
     */
    public CustomTag(me.snowdrop.istio.api.mesh.v1alpha1.CustomTag.Type type) {
        super();
        this.type = type;
    }

    public me.snowdrop.istio.api.mesh.v1alpha1.CustomTag.Type getType() {
        return type;
    }

    public void setType(me.snowdrop.istio.api.mesh.v1alpha1.CustomTag.Type type) {
        this.type = type;
    }

    public interface Type extends Serializable
    {


    }

}
