package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomTagBuilder extends CustomTagFluentImpl<CustomTagBuilder> implements VisitableBuilder<CustomTag,CustomTagBuilder>{

    CustomTagFluent<?> fluent;
    Boolean validationEnabled;

    public CustomTagBuilder(){
            this(true);
    }
    public CustomTagBuilder(Boolean validationEnabled){
            this(new CustomTag(), validationEnabled);
    }
    public CustomTagBuilder(CustomTagFluent<?> fluent){
            this(fluent, true);
    }
    public CustomTagBuilder(CustomTagFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CustomTag(), validationEnabled);
    }
    public CustomTagBuilder(CustomTagFluent<?> fluent,CustomTag instance){
            this(fluent, instance, true);
    }
    public CustomTagBuilder(CustomTagFluent<?> fluent,CustomTag instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public CustomTagBuilder(CustomTag instance){
            this(instance,true);
    }
    public CustomTagBuilder(CustomTag instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public CustomTag build(){
            CustomTag buildable = new CustomTag(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CustomTagBuilder that = (CustomTagBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
