package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EnvironmentBuilder extends EnvironmentFluentImpl<EnvironmentBuilder> implements VisitableBuilder<Environment,EnvironmentBuilder>{

    EnvironmentFluent<?> fluent;
    Boolean validationEnabled;

    public EnvironmentBuilder(){
            this(true);
    }
    public EnvironmentBuilder(Boolean validationEnabled){
            this(new Environment(), validationEnabled);
    }
    public EnvironmentBuilder(EnvironmentFluent<?> fluent){
            this(fluent, true);
    }
    public EnvironmentBuilder(EnvironmentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Environment(), validationEnabled);
    }
    public EnvironmentBuilder(EnvironmentFluent<?> fluent,Environment instance){
            this(fluent, instance, true);
    }
    public EnvironmentBuilder(EnvironmentFluent<?> fluent,Environment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefaultValue(instance.getDefaultValue()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public EnvironmentBuilder(Environment instance){
            this(instance,true);
    }
    public EnvironmentBuilder(Environment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefaultValue(instance.getDefaultValue()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public Environment build(){
            Environment buildable = new Environment(fluent.getDefaultValue(),fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvironmentBuilder that = (EnvironmentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
