
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.mesh.v1alpha1.CustomTag.Type;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "environment"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class EnvironmentType implements Serializable, Type
{

    /**
     * 
     */
    @JsonProperty("environment")
    @JsonPropertyDescription("")
    private Environment environment;
    private final static long serialVersionUID = -9163990234431361051L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EnvironmentType() {
    }

    /**
     * 
     * @param environment
     */
    public EnvironmentType(Environment environment) {
        super();
        this.environment = environment;
    }

    /**
     * 
     */
    public Environment getEnvironment() {
        return environment;
    }

    /**
     * 
     */
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

}
