
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.mesh.v1alpha1.CustomTag.Type;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "header"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HeaderType implements Serializable, Type
{

    /**
     * 
     */
    @JsonProperty("header")
    @JsonPropertyDescription("")
    private RequestHeader header;
    private final static long serialVersionUID = 7353374881323970661L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HeaderType() {
    }

    /**
     * 
     * @param header
     */
    public HeaderType(RequestHeader header) {
        super();
        this.header = header;
    }

    /**
     * 
     */
    public RequestHeader getHeader() {
        return header;
    }

    /**
     * 
     */
    public void setHeader(RequestHeader header) {
        this.header = header;
    }

}
