package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HeaderTypeBuilder extends HeaderTypeFluentImpl<HeaderTypeBuilder> implements VisitableBuilder<HeaderType,HeaderTypeBuilder>{

    HeaderTypeFluent<?> fluent;
    Boolean validationEnabled;

    public HeaderTypeBuilder(){
            this(true);
    }
    public HeaderTypeBuilder(Boolean validationEnabled){
            this(new HeaderType(), validationEnabled);
    }
    public HeaderTypeBuilder(HeaderTypeFluent<?> fluent){
            this(fluent, true);
    }
    public HeaderTypeBuilder(HeaderTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HeaderType(), validationEnabled);
    }
    public HeaderTypeBuilder(HeaderTypeFluent<?> fluent,HeaderType instance){
            this(fluent, instance, true);
    }
    public HeaderTypeBuilder(HeaderTypeFluent<?> fluent,HeaderType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHeader(instance.getHeader()); 
            this.validationEnabled = validationEnabled; 
    }
    public HeaderTypeBuilder(HeaderType instance){
            this(instance,true);
    }
    public HeaderTypeBuilder(HeaderType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHeader(instance.getHeader()); 
            this.validationEnabled = validationEnabled; 
    }

    public HeaderType build(){
            HeaderType buildable = new HeaderType(fluent.getHeader());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HeaderTypeBuilder that = (HeaderTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
