
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "value"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Literal implements Serializable
{

    /**
     * 
     */
    @JsonProperty("value")
    @JsonPropertyDescription("")
    private String value;
    private final static long serialVersionUID = 102902858337932791L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Literal() {
    }

    /**
     * 
     * @param value
     */
    public Literal(String value) {
        super();
        this.value = value;
    }

    /**
     * 
     */
    public String getValue() {
        return value;
    }

    /**
     * 
     */
    public void setValue(String value) {
        this.value = value;
    }

}
