package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LiteralBuilder extends LiteralFluentImpl<LiteralBuilder> implements VisitableBuilder<Literal,LiteralBuilder>{

    LiteralFluent<?> fluent;
    Boolean validationEnabled;

    public LiteralBuilder(){
            this(true);
    }
    public LiteralBuilder(Boolean validationEnabled){
            this(new Literal(), validationEnabled);
    }
    public LiteralBuilder(LiteralFluent<?> fluent){
            this(fluent, true);
    }
    public LiteralBuilder(LiteralFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Literal(), validationEnabled);
    }
    public LiteralBuilder(LiteralFluent<?> fluent,Literal instance){
            this(fluent, instance, true);
    }
    public LiteralBuilder(LiteralFluent<?> fluent,Literal instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public LiteralBuilder(Literal instance){
            this(instance,true);
    }
    public LiteralBuilder(Literal instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public Literal build(){
            Literal buildable = new Literal(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LiteralBuilder that = (LiteralBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
