
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.mesh.v1alpha1.CustomTag.Type;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "literal"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class LiteralType implements Serializable, Type
{

    /**
     * 
     */
    @JsonProperty("literal")
    @JsonPropertyDescription("")
    private Literal literal;
    private final static long serialVersionUID = 2129580147522877972L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LiteralType() {
    }

    /**
     * 
     * @param literal
     */
    public LiteralType(Literal literal) {
        super();
        this.literal = literal;
    }

    /**
     * 
     */
    public Literal getLiteral() {
        return literal;
    }

    /**
     * 
     */
    public void setLiteral(Literal literal) {
        this.literal = literal;
    }

}
