package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LiteralTypeBuilder extends LiteralTypeFluentImpl<LiteralTypeBuilder> implements VisitableBuilder<LiteralType,LiteralTypeBuilder>{

    LiteralTypeFluent<?> fluent;
    Boolean validationEnabled;

    public LiteralTypeBuilder(){
            this(true);
    }
    public LiteralTypeBuilder(Boolean validationEnabled){
            this(new LiteralType(), validationEnabled);
    }
    public LiteralTypeBuilder(LiteralTypeFluent<?> fluent){
            this(fluent, true);
    }
    public LiteralTypeBuilder(LiteralTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LiteralType(), validationEnabled);
    }
    public LiteralTypeBuilder(LiteralTypeFluent<?> fluent,LiteralType instance){
            this(fluent, instance, true);
    }
    public LiteralTypeBuilder(LiteralTypeFluent<?> fluent,LiteralType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLiteral(instance.getLiteral()); 
            this.validationEnabled = validationEnabled; 
    }
    public LiteralTypeBuilder(LiteralType instance){
            this(instance,true);
    }
    public LiteralTypeBuilder(LiteralType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLiteral(instance.getLiteral()); 
            this.validationEnabled = validationEnabled; 
    }

    public LiteralType build(){
            LiteralType buildable = new LiteralType(fluent.getLiteral());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LiteralTypeBuilder that = (LiteralTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
