
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;
import me.snowdrop.istio.api.networking.v1alpha3.LocalityLoadBalancerSetting;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepalive;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "accessLogEncoding",
    "accessLogFile",
    "accessLogFormat",
    "authPolicy",
    "certificates",
    "configSources",
    "connectTimeout",
    "defaultConfig",
    "defaultDestinationRuleExportTo",
    "defaultServiceExportTo",
    "defaultVirtualServiceExportTo",
    "disableMixerHttpReports",
    "disablePolicyChecks",
    "disableReportBatch",
    "dnsRefreshRate",
    "enableAutoMtls",
    "enableClientSidePolicyCheck",
    "enableEnvoyAccessLogService",
    "enablePrometheusMerge",
    "enableSdsTokenMount",
    "enableTracing",
    "h2UpgradePolicy",
    "inboundClusterStatName",
    "ingressClass",
    "ingressControllerMode",
    "ingressSelector",
    "ingressService",
    "localityLbSetting",
    "mixerAddress",
    "mixerCheckServer",
    "mixerReportServer",
    "outboundClusterStatName",
    "outboundTrafficPolicy",
    "policyCheckFailOpen",
    "protocolDetectionTimeout",
    "proxyHttpPort",
    "proxyListenPort",
    "rdsRefreshDelay",
    "reportBatchMaxEntries",
    "reportBatchMaxTime",
    "rootNamespace",
    "sdsRefreshDelay",
    "sdsUdsPath",
    "sdsUseK8sSaJwt",
    "serviceSettings",
    "sidecarToTelemetrySessionAffinity",
    "tcpKeepalive",
    "thriftConfig",
    "trustDomain",
    "trustDomainAliases"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MeshConfig implements Serializable
{

    @JsonProperty("accessLogEncoding")
    private AccessLogEncoding accessLogEncoding;
    /**
     * 
     */
    @JsonProperty("accessLogFile")
    @JsonPropertyDescription("")
    private String accessLogFile;
    /**
     * 
     */
    @JsonProperty("accessLogFormat")
    @JsonPropertyDescription("")
    private String accessLogFormat;
    @JsonProperty("authPolicy")
    private AuthenticationPolicy authPolicy;
    /**
     * 
     */
    @JsonProperty("certificates")
    @JsonPropertyDescription("")
    private List<Certificate> certificates = new ArrayList<Certificate>();
    /**
     * 
     */
    @JsonProperty("configSources")
    @JsonPropertyDescription("")
    private List<ConfigSource> configSources = new ArrayList<ConfigSource>();
    /**
     * 
     */
    @JsonProperty("connectTimeout")
    @JsonPropertyDescription("")
    private Duration connectTimeout;
    /**
     * 
     */
    @JsonProperty("defaultConfig")
    @JsonPropertyDescription("")
    private ProxyConfig defaultConfig;
    /**
     * 
     */
    @JsonProperty("defaultDestinationRuleExportTo")
    @JsonPropertyDescription("")
    private List<String> defaultDestinationRuleExportTo = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("defaultServiceExportTo")
    @JsonPropertyDescription("")
    private List<String> defaultServiceExportTo = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("defaultVirtualServiceExportTo")
    @JsonPropertyDescription("")
    private List<String> defaultVirtualServiceExportTo = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("disableMixerHttpReports")
    @JsonPropertyDescription("")
    private java.lang.Boolean disableMixerHttpReports;
    /**
     * 
     */
    @JsonProperty("disablePolicyChecks")
    @JsonPropertyDescription("")
    private java.lang.Boolean disablePolicyChecks;
    /**
     * 
     */
    @JsonProperty("disableReportBatch")
    @JsonPropertyDescription("")
    private java.lang.Boolean disableReportBatch;
    /**
     * 
     */
    @JsonProperty("dnsRefreshRate")
    @JsonPropertyDescription("")
    private Duration dnsRefreshRate;
    @JsonProperty("enableAutoMtls")
    private Boolean enableAutoMtls;
    /**
     * 
     */
    @JsonProperty("enableClientSidePolicyCheck")
    @JsonPropertyDescription("")
    private java.lang.Boolean enableClientSidePolicyCheck;
    /**
     * 
     */
    @JsonProperty("enableEnvoyAccessLogService")
    @JsonPropertyDescription("")
    private java.lang.Boolean enableEnvoyAccessLogService;
    @JsonProperty("enablePrometheusMerge")
    private Boolean enablePrometheusMerge;
    /**
     * 
     */
    @JsonProperty("enableSdsTokenMount")
    @JsonPropertyDescription("")
    private java.lang.Boolean enableSdsTokenMount;
    /**
     * 
     */
    @JsonProperty("enableTracing")
    @JsonPropertyDescription("")
    private java.lang.Boolean enableTracing;
    @JsonProperty("h2UpgradePolicy")
    private H2UpgradePolicy h2UpgradePolicy;
    /**
     * 
     */
    @JsonProperty("inboundClusterStatName")
    @JsonPropertyDescription("")
    private String inboundClusterStatName;
    /**
     * 
     */
    @JsonProperty("ingressClass")
    @JsonPropertyDescription("")
    private String ingressClass;
    @JsonProperty("ingressControllerMode")
    private IngressControllerMode ingressControllerMode;
    /**
     * 
     */
    @JsonProperty("ingressSelector")
    @JsonPropertyDescription("")
    private String ingressSelector;
    /**
     * 
     */
    @JsonProperty("ingressService")
    @JsonPropertyDescription("")
    private String ingressService;
    /**
     * 
     */
    @JsonProperty("localityLbSetting")
    @JsonPropertyDescription("")
    private LocalityLoadBalancerSetting localityLbSetting;
    /**
     * 
     */
    @JsonProperty("mixerAddress")
    @JsonPropertyDescription("")
    private String mixerAddress;
    /**
     * 
     */
    @JsonProperty("mixerCheckServer")
    @JsonPropertyDescription("")
    private String mixerCheckServer;
    /**
     * 
     */
    @JsonProperty("mixerReportServer")
    @JsonPropertyDescription("")
    private String mixerReportServer;
    /**
     * 
     */
    @JsonProperty("outboundClusterStatName")
    @JsonPropertyDescription("")
    private String outboundClusterStatName;
    /**
     * 
     */
    @JsonProperty("outboundTrafficPolicy")
    @JsonPropertyDescription("")
    private OutboundTrafficPolicy outboundTrafficPolicy;
    /**
     * 
     */
    @JsonProperty("policyCheckFailOpen")
    @JsonPropertyDescription("")
    private java.lang.Boolean policyCheckFailOpen;
    /**
     * 
     */
    @JsonProperty("protocolDetectionTimeout")
    @JsonPropertyDescription("")
    private Duration protocolDetectionTimeout;
    /**
     * 
     */
    @JsonProperty("proxyHttpPort")
    @JsonPropertyDescription("")
    private Integer proxyHttpPort;
    /**
     * 
     */
    @JsonProperty("proxyListenPort")
    @JsonPropertyDescription("")
    private Integer proxyListenPort;
    /**
     * 
     */
    @JsonProperty("rdsRefreshDelay")
    @JsonPropertyDescription("")
    private Duration rdsRefreshDelay;
    /**
     * 
     */
    @JsonProperty("reportBatchMaxEntries")
    @JsonPropertyDescription("")
    private Integer reportBatchMaxEntries;
    /**
     * 
     */
    @JsonProperty("reportBatchMaxTime")
    @JsonPropertyDescription("")
    private Duration reportBatchMaxTime;
    /**
     * 
     */
    @JsonProperty("rootNamespace")
    @JsonPropertyDescription("")
    private String rootNamespace;
    /**
     * 
     */
    @JsonProperty("sdsRefreshDelay")
    @JsonPropertyDescription("")
    private Duration sdsRefreshDelay;
    /**
     * 
     */
    @JsonProperty("sdsUdsPath")
    @JsonPropertyDescription("")
    private String sdsUdsPath;
    /**
     * 
     */
    @JsonProperty("sdsUseK8sSaJwt")
    @JsonPropertyDescription("")
    private java.lang.Boolean sdsUseK8sSaJwt;
    /**
     * 
     */
    @JsonProperty("serviceSettings")
    @JsonPropertyDescription("")
    private List<ServiceSettings> serviceSettings = new ArrayList<ServiceSettings>();
    /**
     * 
     */
    @JsonProperty("sidecarToTelemetrySessionAffinity")
    @JsonPropertyDescription("")
    private java.lang.Boolean sidecarToTelemetrySessionAffinity;
    /**
     * 
     */
    @JsonProperty("tcpKeepalive")
    @JsonPropertyDescription("")
    private TcpKeepalive tcpKeepalive;
    /**
     * 
     */
    @JsonProperty("thriftConfig")
    @JsonPropertyDescription("")
    private ThriftConfig thriftConfig;
    /**
     * 
     */
    @JsonProperty("trustDomain")
    @JsonPropertyDescription("")
    private String trustDomain;
    /**
     * 
     */
    @JsonProperty("trustDomainAliases")
    @JsonPropertyDescription("")
    private List<String> trustDomainAliases = new ArrayList<String>();
    private final static long serialVersionUID = -5692252576803255878L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MeshConfig() {
    }

    /**
     * 
     * @param outboundClusterStatName
     * @param sdsUseK8sSaJwt
     * @param enableClientSidePolicyCheck
     * @param dnsRefreshRate
     * @param authPolicy
     * @param protocolDetectionTimeout
     * @param thriftConfig
     * @param ingressControllerMode
     * @param mixerReportServer
     * @param defaultServiceExportTo
     * @param configSources
     * @param reportBatchMaxEntries
     * @param defaultVirtualServiceExportTo
     * @param disableMixerHttpReports
     * @param sdsUdsPath
     * @param defaultConfig
     * @param connectTimeout
     * @param enableSdsTokenMount
     * @param proxyListenPort
     * @param policyCheckFailOpen
     * @param enableTracing
     * @param serviceSettings
     * @param trustDomainAliases
     * @param ingressService
     * @param rdsRefreshDelay
     * @param certificates
     * @param localityLbSetting
     * @param h2UpgradePolicy
     * @param enablePrometheusMerge
     * @param ingressSelector
     * @param ingressClass
     * @param reportBatchMaxTime
     * @param inboundClusterStatName
     * @param disablePolicyChecks
     * @param trustDomain
     * @param defaultDestinationRuleExportTo
     * @param sidecarToTelemetrySessionAffinity
     * @param mixerAddress
     * @param accessLogEncoding
     * @param sdsRefreshDelay
     * @param enableAutoMtls
     * @param accessLogFile
     * @param mixerCheckServer
     * @param accessLogFormat
     * @param outboundTrafficPolicy
     * @param proxyHttpPort
     * @param disableReportBatch
     * @param enableEnvoyAccessLogService
     * @param tcpKeepalive
     * @param rootNamespace
     */
    public MeshConfig(AccessLogEncoding accessLogEncoding, String accessLogFile, String accessLogFormat, AuthenticationPolicy authPolicy, List<Certificate> certificates, List<ConfigSource> configSources, Duration connectTimeout, ProxyConfig defaultConfig, List<String> defaultDestinationRuleExportTo, List<String> defaultServiceExportTo, List<String> defaultVirtualServiceExportTo, java.lang.Boolean disableMixerHttpReports, java.lang.Boolean disablePolicyChecks, java.lang.Boolean disableReportBatch, Duration dnsRefreshRate, Boolean enableAutoMtls, java.lang.Boolean enableClientSidePolicyCheck, java.lang.Boolean enableEnvoyAccessLogService, Boolean enablePrometheusMerge, java.lang.Boolean enableSdsTokenMount, java.lang.Boolean enableTracing, H2UpgradePolicy h2UpgradePolicy, String inboundClusterStatName, String ingressClass, IngressControllerMode ingressControllerMode, String ingressSelector, String ingressService, LocalityLoadBalancerSetting localityLbSetting, String mixerAddress, String mixerCheckServer, String mixerReportServer, String outboundClusterStatName, OutboundTrafficPolicy outboundTrafficPolicy, java.lang.Boolean policyCheckFailOpen, Duration protocolDetectionTimeout, Integer proxyHttpPort, Integer proxyListenPort, Duration rdsRefreshDelay, Integer reportBatchMaxEntries, Duration reportBatchMaxTime, String rootNamespace, Duration sdsRefreshDelay, String sdsUdsPath, java.lang.Boolean sdsUseK8sSaJwt, List<ServiceSettings> serviceSettings, java.lang.Boolean sidecarToTelemetrySessionAffinity, TcpKeepalive tcpKeepalive, ThriftConfig thriftConfig, String trustDomain, List<String> trustDomainAliases) {
        super();
        this.accessLogEncoding = accessLogEncoding;
        this.accessLogFile = accessLogFile;
        this.accessLogFormat = accessLogFormat;
        this.authPolicy = authPolicy;
        this.certificates = certificates;
        this.configSources = configSources;
        this.connectTimeout = connectTimeout;
        this.defaultConfig = defaultConfig;
        this.defaultDestinationRuleExportTo = defaultDestinationRuleExportTo;
        this.defaultServiceExportTo = defaultServiceExportTo;
        this.defaultVirtualServiceExportTo = defaultVirtualServiceExportTo;
        this.disableMixerHttpReports = disableMixerHttpReports;
        this.disablePolicyChecks = disablePolicyChecks;
        this.disableReportBatch = disableReportBatch;
        this.dnsRefreshRate = dnsRefreshRate;
        this.enableAutoMtls = enableAutoMtls;
        this.enableClientSidePolicyCheck = enableClientSidePolicyCheck;
        this.enableEnvoyAccessLogService = enableEnvoyAccessLogService;
        this.enablePrometheusMerge = enablePrometheusMerge;
        this.enableSdsTokenMount = enableSdsTokenMount;
        this.enableTracing = enableTracing;
        this.h2UpgradePolicy = h2UpgradePolicy;
        this.inboundClusterStatName = inboundClusterStatName;
        this.ingressClass = ingressClass;
        this.ingressControllerMode = ingressControllerMode;
        this.ingressSelector = ingressSelector;
        this.ingressService = ingressService;
        this.localityLbSetting = localityLbSetting;
        this.mixerAddress = mixerAddress;
        this.mixerCheckServer = mixerCheckServer;
        this.mixerReportServer = mixerReportServer;
        this.outboundClusterStatName = outboundClusterStatName;
        this.outboundTrafficPolicy = outboundTrafficPolicy;
        this.policyCheckFailOpen = policyCheckFailOpen;
        this.protocolDetectionTimeout = protocolDetectionTimeout;
        this.proxyHttpPort = proxyHttpPort;
        this.proxyListenPort = proxyListenPort;
        this.rdsRefreshDelay = rdsRefreshDelay;
        this.reportBatchMaxEntries = reportBatchMaxEntries;
        this.reportBatchMaxTime = reportBatchMaxTime;
        this.rootNamespace = rootNamespace;
        this.sdsRefreshDelay = sdsRefreshDelay;
        this.sdsUdsPath = sdsUdsPath;
        this.sdsUseK8sSaJwt = sdsUseK8sSaJwt;
        this.serviceSettings = serviceSettings;
        this.sidecarToTelemetrySessionAffinity = sidecarToTelemetrySessionAffinity;
        this.tcpKeepalive = tcpKeepalive;
        this.thriftConfig = thriftConfig;
        this.trustDomain = trustDomain;
        this.trustDomainAliases = trustDomainAliases;
    }

    public AccessLogEncoding getAccessLogEncoding() {
        return accessLogEncoding;
    }

    public void setAccessLogEncoding(AccessLogEncoding accessLogEncoding) {
        this.accessLogEncoding = accessLogEncoding;
    }

    /**
     * 
     */
    public String getAccessLogFile() {
        return accessLogFile;
    }

    /**
     * 
     */
    public void setAccessLogFile(String accessLogFile) {
        this.accessLogFile = accessLogFile;
    }

    /**
     * 
     */
    public String getAccessLogFormat() {
        return accessLogFormat;
    }

    /**
     * 
     */
    public void setAccessLogFormat(String accessLogFormat) {
        this.accessLogFormat = accessLogFormat;
    }

    public AuthenticationPolicy getAuthPolicy() {
        return authPolicy;
    }

    public void setAuthPolicy(AuthenticationPolicy authPolicy) {
        this.authPolicy = authPolicy;
    }

    /**
     * 
     */
    public List<Certificate> getCertificates() {
        return certificates;
    }

    /**
     * 
     */
    public void setCertificates(List<Certificate> certificates) {
        this.certificates = certificates;
    }

    /**
     * 
     */
    public List<ConfigSource> getConfigSources() {
        return configSources;
    }

    /**
     * 
     */
    public void setConfigSources(List<ConfigSource> configSources) {
        this.configSources = configSources;
    }

    /**
     * 
     */
    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * 
     */
    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /**
     * 
     */
    public ProxyConfig getDefaultConfig() {
        return defaultConfig;
    }

    /**
     * 
     */
    public void setDefaultConfig(ProxyConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    /**
     * 
     */
    public List<String> getDefaultDestinationRuleExportTo() {
        return defaultDestinationRuleExportTo;
    }

    /**
     * 
     */
    public void setDefaultDestinationRuleExportTo(List<String> defaultDestinationRuleExportTo) {
        this.defaultDestinationRuleExportTo = defaultDestinationRuleExportTo;
    }

    /**
     * 
     */
    public List<String> getDefaultServiceExportTo() {
        return defaultServiceExportTo;
    }

    /**
     * 
     */
    public void setDefaultServiceExportTo(List<String> defaultServiceExportTo) {
        this.defaultServiceExportTo = defaultServiceExportTo;
    }

    /**
     * 
     */
    public List<String> getDefaultVirtualServiceExportTo() {
        return defaultVirtualServiceExportTo;
    }

    /**
     * 
     */
    public void setDefaultVirtualServiceExportTo(List<String> defaultVirtualServiceExportTo) {
        this.defaultVirtualServiceExportTo = defaultVirtualServiceExportTo;
    }

    /**
     * 
     */
    public java.lang.Boolean getDisableMixerHttpReports() {
        return disableMixerHttpReports;
    }

    /**
     * 
     */
    public void setDisableMixerHttpReports(java.lang.Boolean disableMixerHttpReports) {
        this.disableMixerHttpReports = disableMixerHttpReports;
    }

    /**
     * 
     */
    public java.lang.Boolean getDisablePolicyChecks() {
        return disablePolicyChecks;
    }

    /**
     * 
     */
    public void setDisablePolicyChecks(java.lang.Boolean disablePolicyChecks) {
        this.disablePolicyChecks = disablePolicyChecks;
    }

    /**
     * 
     */
    public java.lang.Boolean getDisableReportBatch() {
        return disableReportBatch;
    }

    /**
     * 
     */
    public void setDisableReportBatch(java.lang.Boolean disableReportBatch) {
        this.disableReportBatch = disableReportBatch;
    }

    /**
     * 
     */
    public Duration getDnsRefreshRate() {
        return dnsRefreshRate;
    }

    /**
     * 
     */
    public void setDnsRefreshRate(Duration dnsRefreshRate) {
        this.dnsRefreshRate = dnsRefreshRate;
    }

    public Boolean getEnableAutoMtls() {
        return enableAutoMtls;
    }

    public void setEnableAutoMtls(Boolean enableAutoMtls) {
        this.enableAutoMtls = enableAutoMtls;
    }

    /**
     * 
     */
    public java.lang.Boolean getEnableClientSidePolicyCheck() {
        return enableClientSidePolicyCheck;
    }

    /**
     * 
     */
    public void setEnableClientSidePolicyCheck(java.lang.Boolean enableClientSidePolicyCheck) {
        this.enableClientSidePolicyCheck = enableClientSidePolicyCheck;
    }

    /**
     * 
     */
    public java.lang.Boolean getEnableEnvoyAccessLogService() {
        return enableEnvoyAccessLogService;
    }

    /**
     * 
     */
    public void setEnableEnvoyAccessLogService(java.lang.Boolean enableEnvoyAccessLogService) {
        this.enableEnvoyAccessLogService = enableEnvoyAccessLogService;
    }

    public Boolean getEnablePrometheusMerge() {
        return enablePrometheusMerge;
    }

    public void setEnablePrometheusMerge(Boolean enablePrometheusMerge) {
        this.enablePrometheusMerge = enablePrometheusMerge;
    }

    /**
     * 
     */
    public java.lang.Boolean getEnableSdsTokenMount() {
        return enableSdsTokenMount;
    }

    /**
     * 
     */
    public void setEnableSdsTokenMount(java.lang.Boolean enableSdsTokenMount) {
        this.enableSdsTokenMount = enableSdsTokenMount;
    }

    /**
     * 
     */
    public java.lang.Boolean getEnableTracing() {
        return enableTracing;
    }

    /**
     * 
     */
    public void setEnableTracing(java.lang.Boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    public H2UpgradePolicy getH2UpgradePolicy() {
        return h2UpgradePolicy;
    }

    public void setH2UpgradePolicy(H2UpgradePolicy h2UpgradePolicy) {
        this.h2UpgradePolicy = h2UpgradePolicy;
    }

    /**
     * 
     */
    public String getInboundClusterStatName() {
        return inboundClusterStatName;
    }

    /**
     * 
     */
    public void setInboundClusterStatName(String inboundClusterStatName) {
        this.inboundClusterStatName = inboundClusterStatName;
    }

    /**
     * 
     */
    public String getIngressClass() {
        return ingressClass;
    }

    /**
     * 
     */
    public void setIngressClass(String ingressClass) {
        this.ingressClass = ingressClass;
    }

    public IngressControllerMode getIngressControllerMode() {
        return ingressControllerMode;
    }

    public void setIngressControllerMode(IngressControllerMode ingressControllerMode) {
        this.ingressControllerMode = ingressControllerMode;
    }

    /**
     * 
     */
    public String getIngressSelector() {
        return ingressSelector;
    }

    /**
     * 
     */
    public void setIngressSelector(String ingressSelector) {
        this.ingressSelector = ingressSelector;
    }

    /**
     * 
     */
    public String getIngressService() {
        return ingressService;
    }

    /**
     * 
     */
    public void setIngressService(String ingressService) {
        this.ingressService = ingressService;
    }

    /**
     * 
     */
    public LocalityLoadBalancerSetting getLocalityLbSetting() {
        return localityLbSetting;
    }

    /**
     * 
     */
    public void setLocalityLbSetting(LocalityLoadBalancerSetting localityLbSetting) {
        this.localityLbSetting = localityLbSetting;
    }

    /**
     * 
     */
    public String getMixerAddress() {
        return mixerAddress;
    }

    /**
     * 
     */
    public void setMixerAddress(String mixerAddress) {
        this.mixerAddress = mixerAddress;
    }

    /**
     * 
     */
    public String getMixerCheckServer() {
        return mixerCheckServer;
    }

    /**
     * 
     */
    public void setMixerCheckServer(String mixerCheckServer) {
        this.mixerCheckServer = mixerCheckServer;
    }

    /**
     * 
     */
    public String getMixerReportServer() {
        return mixerReportServer;
    }

    /**
     * 
     */
    public void setMixerReportServer(String mixerReportServer) {
        this.mixerReportServer = mixerReportServer;
    }

    /**
     * 
     */
    public String getOutboundClusterStatName() {
        return outboundClusterStatName;
    }

    /**
     * 
     */
    public void setOutboundClusterStatName(String outboundClusterStatName) {
        this.outboundClusterStatName = outboundClusterStatName;
    }

    /**
     * 
     */
    public OutboundTrafficPolicy getOutboundTrafficPolicy() {
        return outboundTrafficPolicy;
    }

    /**
     * 
     */
    public void setOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy) {
        this.outboundTrafficPolicy = outboundTrafficPolicy;
    }

    /**
     * 
     */
    public java.lang.Boolean getPolicyCheckFailOpen() {
        return policyCheckFailOpen;
    }

    /**
     * 
     */
    public void setPolicyCheckFailOpen(java.lang.Boolean policyCheckFailOpen) {
        this.policyCheckFailOpen = policyCheckFailOpen;
    }

    /**
     * 
     */
    public Duration getProtocolDetectionTimeout() {
        return protocolDetectionTimeout;
    }

    /**
     * 
     */
    public void setProtocolDetectionTimeout(Duration protocolDetectionTimeout) {
        this.protocolDetectionTimeout = protocolDetectionTimeout;
    }

    /**
     * 
     */
    public Integer getProxyHttpPort() {
        return proxyHttpPort;
    }

    /**
     * 
     */
    public void setProxyHttpPort(Integer proxyHttpPort) {
        this.proxyHttpPort = proxyHttpPort;
    }

    /**
     * 
     */
    public Integer getProxyListenPort() {
        return proxyListenPort;
    }

    /**
     * 
     */
    public void setProxyListenPort(Integer proxyListenPort) {
        this.proxyListenPort = proxyListenPort;
    }

    /**
     * 
     */
    public Duration getRdsRefreshDelay() {
        return rdsRefreshDelay;
    }

    /**
     * 
     */
    public void setRdsRefreshDelay(Duration rdsRefreshDelay) {
        this.rdsRefreshDelay = rdsRefreshDelay;
    }

    /**
     * 
     */
    public Integer getReportBatchMaxEntries() {
        return reportBatchMaxEntries;
    }

    /**
     * 
     */
    public void setReportBatchMaxEntries(Integer reportBatchMaxEntries) {
        this.reportBatchMaxEntries = reportBatchMaxEntries;
    }

    /**
     * 
     */
    public Duration getReportBatchMaxTime() {
        return reportBatchMaxTime;
    }

    /**
     * 
     */
    public void setReportBatchMaxTime(Duration reportBatchMaxTime) {
        this.reportBatchMaxTime = reportBatchMaxTime;
    }

    /**
     * 
     */
    public String getRootNamespace() {
        return rootNamespace;
    }

    /**
     * 
     */
    public void setRootNamespace(String rootNamespace) {
        this.rootNamespace = rootNamespace;
    }

    /**
     * 
     */
    public Duration getSdsRefreshDelay() {
        return sdsRefreshDelay;
    }

    /**
     * 
     */
    public void setSdsRefreshDelay(Duration sdsRefreshDelay) {
        this.sdsRefreshDelay = sdsRefreshDelay;
    }

    /**
     * 
     */
    public String getSdsUdsPath() {
        return sdsUdsPath;
    }

    /**
     * 
     */
    public void setSdsUdsPath(String sdsUdsPath) {
        this.sdsUdsPath = sdsUdsPath;
    }

    /**
     * 
     */
    public java.lang.Boolean getSdsUseK8sSaJwt() {
        return sdsUseK8sSaJwt;
    }

    /**
     * 
     */
    public void setSdsUseK8sSaJwt(java.lang.Boolean sdsUseK8sSaJwt) {
        this.sdsUseK8sSaJwt = sdsUseK8sSaJwt;
    }

    /**
     * 
     */
    public List<ServiceSettings> getServiceSettings() {
        return serviceSettings;
    }

    /**
     * 
     */
    public void setServiceSettings(List<ServiceSettings> serviceSettings) {
        this.serviceSettings = serviceSettings;
    }

    /**
     * 
     */
    public java.lang.Boolean getSidecarToTelemetrySessionAffinity() {
        return sidecarToTelemetrySessionAffinity;
    }

    /**
     * 
     */
    public void setSidecarToTelemetrySessionAffinity(java.lang.Boolean sidecarToTelemetrySessionAffinity) {
        this.sidecarToTelemetrySessionAffinity = sidecarToTelemetrySessionAffinity;
    }

    /**
     * 
     */
    public TcpKeepalive getTcpKeepalive() {
        return tcpKeepalive;
    }

    /**
     * 
     */
    public void setTcpKeepalive(TcpKeepalive tcpKeepalive) {
        this.tcpKeepalive = tcpKeepalive;
    }

    /**
     * 
     */
    public ThriftConfig getThriftConfig() {
        return thriftConfig;
    }

    /**
     * 
     */
    public void setThriftConfig(ThriftConfig thriftConfig) {
        this.thriftConfig = thriftConfig;
    }

    /**
     * 
     */
    public String getTrustDomain() {
        return trustDomain;
    }

    /**
     * 
     */
    public void setTrustDomain(String trustDomain) {
        this.trustDomain = trustDomain;
    }

    /**
     * 
     */
    public List<String> getTrustDomainAliases() {
        return trustDomainAliases;
    }

    /**
     * 
     */
    public void setTrustDomainAliases(List<String> trustDomainAliases) {
        this.trustDomainAliases = trustDomainAliases;
    }

}
