package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MeshConfigBuilder extends MeshConfigFluentImpl<MeshConfigBuilder> implements VisitableBuilder<MeshConfig,MeshConfigBuilder>{

    MeshConfigFluent<?> fluent;
    Boolean validationEnabled;

    public MeshConfigBuilder(){
            this(true);
    }
    public MeshConfigBuilder(Boolean validationEnabled){
            this(new MeshConfig(), validationEnabled);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent){
            this(fluent, true);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MeshConfig(), validationEnabled);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,MeshConfig instance){
            this(fluent, instance, true);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,MeshConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccessLogEncoding(instance.getAccessLogEncoding()); 
            fluent.withAccessLogFile(instance.getAccessLogFile()); 
            fluent.withAccessLogFormat(instance.getAccessLogFormat()); 
            fluent.withAuthPolicy(instance.getAuthPolicy()); 
            fluent.withCertificates(instance.getCertificates()); 
            fluent.withConfigSources(instance.getConfigSources()); 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withDefaultConfig(instance.getDefaultConfig()); 
            fluent.withDefaultDestinationRuleExportTo(instance.getDefaultDestinationRuleExportTo()); 
            fluent.withDefaultServiceExportTo(instance.getDefaultServiceExportTo()); 
            fluent.withDefaultVirtualServiceExportTo(instance.getDefaultVirtualServiceExportTo()); 
            fluent.withDisableMixerHttpReports(instance.getDisableMixerHttpReports()); 
            fluent.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            fluent.withDisableReportBatch(instance.getDisableReportBatch()); 
            fluent.withDnsRefreshRate(instance.getDnsRefreshRate()); 
            fluent.withEnableAutoMtls(instance.getEnableAutoMtls()); 
            fluent.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            fluent.withEnableEnvoyAccessLogService(instance.getEnableEnvoyAccessLogService()); 
            fluent.withEnablePrometheusMerge(instance.getEnablePrometheusMerge()); 
            fluent.withEnableSdsTokenMount(instance.getEnableSdsTokenMount()); 
            fluent.withEnableTracing(instance.getEnableTracing()); 
            fluent.withH2UpgradePolicy(instance.getH2UpgradePolicy()); 
            fluent.withInboundClusterStatName(instance.getInboundClusterStatName()); 
            fluent.withIngressClass(instance.getIngressClass()); 
            fluent.withIngressControllerMode(instance.getIngressControllerMode()); 
            fluent.withIngressSelector(instance.getIngressSelector()); 
            fluent.withIngressService(instance.getIngressService()); 
            fluent.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            fluent.withMixerAddress(instance.getMixerAddress()); 
            fluent.withMixerCheckServer(instance.getMixerCheckServer()); 
            fluent.withMixerReportServer(instance.getMixerReportServer()); 
            fluent.withOutboundClusterStatName(instance.getOutboundClusterStatName()); 
            fluent.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            fluent.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            fluent.withProtocolDetectionTimeout(instance.getProtocolDetectionTimeout()); 
            fluent.withProxyHttpPort(instance.getProxyHttpPort()); 
            fluent.withProxyListenPort(instance.getProxyListenPort()); 
            fluent.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            fluent.withReportBatchMaxEntries(instance.getReportBatchMaxEntries()); 
            fluent.withReportBatchMaxTime(instance.getReportBatchMaxTime()); 
            fluent.withRootNamespace(instance.getRootNamespace()); 
            fluent.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            fluent.withSdsUdsPath(instance.getSdsUdsPath()); 
            fluent.withSdsUseK8sSaJwt(instance.getSdsUseK8sSaJwt()); 
            fluent.withServiceSettings(instance.getServiceSettings()); 
            fluent.withSidecarToTelemetrySessionAffinity(instance.getSidecarToTelemetrySessionAffinity()); 
            fluent.withTcpKeepalive(instance.getTcpKeepalive()); 
            fluent.withThriftConfig(instance.getThriftConfig()); 
            fluent.withTrustDomain(instance.getTrustDomain()); 
            fluent.withTrustDomainAliases(instance.getTrustDomainAliases()); 
            this.validationEnabled = validationEnabled; 
    }
    public MeshConfigBuilder(MeshConfig instance){
            this(instance,true);
    }
    public MeshConfigBuilder(MeshConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccessLogEncoding(instance.getAccessLogEncoding()); 
            this.withAccessLogFile(instance.getAccessLogFile()); 
            this.withAccessLogFormat(instance.getAccessLogFormat()); 
            this.withAuthPolicy(instance.getAuthPolicy()); 
            this.withCertificates(instance.getCertificates()); 
            this.withConfigSources(instance.getConfigSources()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withDefaultConfig(instance.getDefaultConfig()); 
            this.withDefaultDestinationRuleExportTo(instance.getDefaultDestinationRuleExportTo()); 
            this.withDefaultServiceExportTo(instance.getDefaultServiceExportTo()); 
            this.withDefaultVirtualServiceExportTo(instance.getDefaultVirtualServiceExportTo()); 
            this.withDisableMixerHttpReports(instance.getDisableMixerHttpReports()); 
            this.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            this.withDisableReportBatch(instance.getDisableReportBatch()); 
            this.withDnsRefreshRate(instance.getDnsRefreshRate()); 
            this.withEnableAutoMtls(instance.getEnableAutoMtls()); 
            this.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            this.withEnableEnvoyAccessLogService(instance.getEnableEnvoyAccessLogService()); 
            this.withEnablePrometheusMerge(instance.getEnablePrometheusMerge()); 
            this.withEnableSdsTokenMount(instance.getEnableSdsTokenMount()); 
            this.withEnableTracing(instance.getEnableTracing()); 
            this.withH2UpgradePolicy(instance.getH2UpgradePolicy()); 
            this.withInboundClusterStatName(instance.getInboundClusterStatName()); 
            this.withIngressClass(instance.getIngressClass()); 
            this.withIngressControllerMode(instance.getIngressControllerMode()); 
            this.withIngressSelector(instance.getIngressSelector()); 
            this.withIngressService(instance.getIngressService()); 
            this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            this.withMixerAddress(instance.getMixerAddress()); 
            this.withMixerCheckServer(instance.getMixerCheckServer()); 
            this.withMixerReportServer(instance.getMixerReportServer()); 
            this.withOutboundClusterStatName(instance.getOutboundClusterStatName()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            this.withProtocolDetectionTimeout(instance.getProtocolDetectionTimeout()); 
            this.withProxyHttpPort(instance.getProxyHttpPort()); 
            this.withProxyListenPort(instance.getProxyListenPort()); 
            this.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            this.withReportBatchMaxEntries(instance.getReportBatchMaxEntries()); 
            this.withReportBatchMaxTime(instance.getReportBatchMaxTime()); 
            this.withRootNamespace(instance.getRootNamespace()); 
            this.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            this.withSdsUdsPath(instance.getSdsUdsPath()); 
            this.withSdsUseK8sSaJwt(instance.getSdsUseK8sSaJwt()); 
            this.withServiceSettings(instance.getServiceSettings()); 
            this.withSidecarToTelemetrySessionAffinity(instance.getSidecarToTelemetrySessionAffinity()); 
            this.withTcpKeepalive(instance.getTcpKeepalive()); 
            this.withThriftConfig(instance.getThriftConfig()); 
            this.withTrustDomain(instance.getTrustDomain()); 
            this.withTrustDomainAliases(instance.getTrustDomainAliases()); 
            this.validationEnabled = validationEnabled; 
    }

    public MeshConfig build(){
            MeshConfig buildable = new MeshConfig(fluent.getAccessLogEncoding(),fluent.getAccessLogFile(),fluent.getAccessLogFormat(),fluent.getAuthPolicy(),fluent.getCertificates(),fluent.getConfigSources(),fluent.getConnectTimeout(),fluent.getDefaultConfig(),fluent.getDefaultDestinationRuleExportTo(),fluent.getDefaultServiceExportTo(),fluent.getDefaultVirtualServiceExportTo(),fluent.isDisableMixerHttpReports(),fluent.isDisablePolicyChecks(),fluent.isDisableReportBatch(),fluent.getDnsRefreshRate(),fluent.isEnableAutoMtls(),fluent.isEnableClientSidePolicyCheck(),fluent.isEnableEnvoyAccessLogService(),fluent.isEnablePrometheusMerge(),fluent.isEnableSdsTokenMount(),fluent.isEnableTracing(),fluent.getH2UpgradePolicy(),fluent.getInboundClusterStatName(),fluent.getIngressClass(),fluent.getIngressControllerMode(),fluent.getIngressSelector(),fluent.getIngressService(),fluent.getLocalityLbSetting(),fluent.getMixerAddress(),fluent.getMixerCheckServer(),fluent.getMixerReportServer(),fluent.getOutboundClusterStatName(),fluent.getOutboundTrafficPolicy(),fluent.isPolicyCheckFailOpen(),fluent.getProtocolDetectionTimeout(),fluent.getProxyHttpPort(),fluent.getProxyListenPort(),fluent.getRdsRefreshDelay(),fluent.getReportBatchMaxEntries(),fluent.getReportBatchMaxTime(),fluent.getRootNamespace(),fluent.getSdsRefreshDelay(),fluent.getSdsUdsPath(),fluent.isSdsUseK8sSaJwt(),fluent.getServiceSettings(),fluent.isSidecarToTelemetrySessionAffinity(),fluent.getTcpKeepalive(),fluent.getThriftConfig(),fluent.getTrustDomain(),fluent.getTrustDomainAliases());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MeshConfigBuilder that = (MeshConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
