package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import me.snowdrop.istio.api.networking.v1alpha3.LocalityLoadBalancerSettingFluent;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepalive;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import me.snowdrop.istio.api.networking.v1alpha3.LocalityLoadBalancerSetting;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepaliveFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.api.Duration;
import java.lang.Long;
import java.util.Collection;
import me.snowdrop.istio.api.DurationBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.Deprecated;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.DurationFluent;
import me.snowdrop.istio.api.networking.v1alpha3.LocalityLoadBalancerSettingBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepaliveBuilder;

public interface MeshConfigFluent<A extends MeshConfigFluent<A>> extends Fluent<A>{


    public AccessLogEncoding getAccessLogEncoding();
    public A withAccessLogEncoding(AccessLogEncoding accessLogEncoding);
    public Boolean hasAccessLogEncoding();
    public String getAccessLogFile();
    public A withAccessLogFile(String accessLogFile);
    public Boolean hasAccessLogFile();
    public A withNewAccessLogFile(String arg1);
    public A withNewAccessLogFile(StringBuilder arg1);
    public A withNewAccessLogFile(StringBuffer arg1);
    public String getAccessLogFormat();
    public A withAccessLogFormat(String accessLogFormat);
    public Boolean hasAccessLogFormat();
    public A withNewAccessLogFormat(String arg1);
    public A withNewAccessLogFormat(StringBuilder arg1);
    public A withNewAccessLogFormat(StringBuffer arg1);
    public AuthenticationPolicy getAuthPolicy();
    public A withAuthPolicy(AuthenticationPolicy authPolicy);
    public Boolean hasAuthPolicy();
    public A addToCertificates(int index,Certificate item);
    public A setToCertificates(int index,Certificate item);
    public A addToCertificates(Certificate... items);
    public A addAllToCertificates(Collection<Certificate> items);
    public A removeFromCertificates(Certificate... items);
    public A removeAllFromCertificates(Collection<Certificate> items);
    public A removeMatchingFromCertificates(io.fabric8.kubernetes.api.builder.Predicate<CertificateBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildCertificates instead.
 * @return The buildable object.
 */
@Deprecated public List<Certificate> getCertificates();
    public List<Certificate> buildCertificates();
    public Certificate buildCertificate(int index);
    public Certificate buildFirstCertificate();
    public Certificate buildLastCertificate();
    public Certificate buildMatchingCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertificateBuilder> predicate);
    public Boolean hasMatchingCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertificateBuilder> predicate);
    public A withCertificates(List<Certificate> certificates);
    public A withCertificates(Certificate... certificates);
    public Boolean hasCertificates();
    public MeshConfigFluent.CertificatesNested<A> addNewCertificate();
    public MeshConfigFluent.CertificatesNested<A> addNewCertificateLike(Certificate item);
    public MeshConfigFluent.CertificatesNested<A> setNewCertificateLike(int index,Certificate item);
    public MeshConfigFluent.CertificatesNested<A> editCertificate(int index);
    public MeshConfigFluent.CertificatesNested<A> editFirstCertificate();
    public MeshConfigFluent.CertificatesNested<A> editLastCertificate();
    public MeshConfigFluent.CertificatesNested<A> editMatchingCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertificateBuilder> predicate);
    public A addToConfigSources(int index,ConfigSource item);
    public A setToConfigSources(int index,ConfigSource item);
    public A addToConfigSources(ConfigSource... items);
    public A addAllToConfigSources(Collection<ConfigSource> items);
    public A removeFromConfigSources(ConfigSource... items);
    public A removeAllFromConfigSources(Collection<ConfigSource> items);
    public A removeMatchingFromConfigSources(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConfigSources instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigSource> getConfigSources();
    public List<ConfigSource> buildConfigSources();
    public ConfigSource buildConfigSource(int index);
    public ConfigSource buildFirstConfigSource();
    public ConfigSource buildLastConfigSource();
    public ConfigSource buildMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate);
    public Boolean hasMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate);
    public A withConfigSources(List<ConfigSource> configSources);
    public A withConfigSources(ConfigSource... configSources);
    public Boolean hasConfigSources();
    public MeshConfigFluent.ConfigSourcesNested<A> addNewConfigSource();
    public MeshConfigFluent.ConfigSourcesNested<A> addNewConfigSourceLike(ConfigSource item);
    public MeshConfigFluent.ConfigSourcesNested<A> setNewConfigSourceLike(int index,ConfigSource item);
    public MeshConfigFluent.ConfigSourcesNested<A> editConfigSource(int index);
    public MeshConfigFluent.ConfigSourcesNested<A> editFirstConfigSource();
    public MeshConfigFluent.ConfigSourcesNested<A> editLastConfigSource();
    public MeshConfigFluent.ConfigSourcesNested<A> editMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout();
    public Duration buildConnectTimeout();
    public A withConnectTimeout(Duration connectTimeout);
    public Boolean hasConnectTimeout();
    public A withNewConnectTimeout(Integer nanos,Long seconds);
    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeout();
    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item);
    public MeshConfigFluent.ConnectTimeoutNested<A> editConnectTimeout();
    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout();
    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item);
    
/**
 * This method has been deprecated, please use method buildDefaultConfig instead.
 * @return The buildable object.
 */
@Deprecated public ProxyConfig getDefaultConfig();
    public ProxyConfig buildDefaultConfig();
    public A withDefaultConfig(ProxyConfig defaultConfig);
    public Boolean hasDefaultConfig();
    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfig();
    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfigLike(ProxyConfig item);
    public MeshConfigFluent.DefaultConfigNested<A> editDefaultConfig();
    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfig();
    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfigLike(ProxyConfig item);
    public A addToDefaultDestinationRuleExportTo(int index,String item);
    public A setToDefaultDestinationRuleExportTo(int index,String item);
    public A addToDefaultDestinationRuleExportTo(String... items);
    public A addAllToDefaultDestinationRuleExportTo(Collection<String> items);
    public A removeFromDefaultDestinationRuleExportTo(String... items);
    public A removeAllFromDefaultDestinationRuleExportTo(Collection<String> items);
    public List<String> getDefaultDestinationRuleExportTo();
    public String getDefaultDestinationRuleExportTo(int index);
    public String getFirstDefaultDestinationRuleExportTo();
    public String getLastDefaultDestinationRuleExportTo();
    public String getMatchingDefaultDestinationRuleExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingDefaultDestinationRuleExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withDefaultDestinationRuleExportTo(List<String> defaultDestinationRuleExportTo);
    public A withDefaultDestinationRuleExportTo(String... defaultDestinationRuleExportTo);
    public Boolean hasDefaultDestinationRuleExportTo();
    public A addNewDefaultDestinationRuleExportTo(String arg1);
    public A addNewDefaultDestinationRuleExportTo(StringBuilder arg1);
    public A addNewDefaultDestinationRuleExportTo(StringBuffer arg1);
    public A addToDefaultServiceExportTo(int index,String item);
    public A setToDefaultServiceExportTo(int index,String item);
    public A addToDefaultServiceExportTo(String... items);
    public A addAllToDefaultServiceExportTo(Collection<String> items);
    public A removeFromDefaultServiceExportTo(String... items);
    public A removeAllFromDefaultServiceExportTo(Collection<String> items);
    public List<String> getDefaultServiceExportTo();
    public String getDefaultServiceExportTo(int index);
    public String getFirstDefaultServiceExportTo();
    public String getLastDefaultServiceExportTo();
    public String getMatchingDefaultServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingDefaultServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withDefaultServiceExportTo(List<String> defaultServiceExportTo);
    public A withDefaultServiceExportTo(String... defaultServiceExportTo);
    public Boolean hasDefaultServiceExportTo();
    public A addNewDefaultServiceExportTo(String arg1);
    public A addNewDefaultServiceExportTo(StringBuilder arg1);
    public A addNewDefaultServiceExportTo(StringBuffer arg1);
    public A addToDefaultVirtualServiceExportTo(int index,String item);
    public A setToDefaultVirtualServiceExportTo(int index,String item);
    public A addToDefaultVirtualServiceExportTo(String... items);
    public A addAllToDefaultVirtualServiceExportTo(Collection<String> items);
    public A removeFromDefaultVirtualServiceExportTo(String... items);
    public A removeAllFromDefaultVirtualServiceExportTo(Collection<String> items);
    public List<String> getDefaultVirtualServiceExportTo();
    public String getDefaultVirtualServiceExportTo(int index);
    public String getFirstDefaultVirtualServiceExportTo();
    public String getLastDefaultVirtualServiceExportTo();
    public String getMatchingDefaultVirtualServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingDefaultVirtualServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withDefaultVirtualServiceExportTo(List<String> defaultVirtualServiceExportTo);
    public A withDefaultVirtualServiceExportTo(String... defaultVirtualServiceExportTo);
    public Boolean hasDefaultVirtualServiceExportTo();
    public A addNewDefaultVirtualServiceExportTo(String arg1);
    public A addNewDefaultVirtualServiceExportTo(StringBuilder arg1);
    public A addNewDefaultVirtualServiceExportTo(StringBuffer arg1);
    public Boolean isDisableMixerHttpReports();
    public A withDisableMixerHttpReports(Boolean disableMixerHttpReports);
    public Boolean hasDisableMixerHttpReports();
    public A withNewDisableMixerHttpReports(String arg1);
    public A withNewDisableMixerHttpReports(boolean arg1);
    public Boolean isDisablePolicyChecks();
    public A withDisablePolicyChecks(Boolean disablePolicyChecks);
    public Boolean hasDisablePolicyChecks();
    public A withNewDisablePolicyChecks(String arg1);
    public A withNewDisablePolicyChecks(boolean arg1);
    public Boolean isDisableReportBatch();
    public A withDisableReportBatch(Boolean disableReportBatch);
    public Boolean hasDisableReportBatch();
    public A withNewDisableReportBatch(String arg1);
    public A withNewDisableReportBatch(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildDnsRefreshRate instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDnsRefreshRate();
    public Duration buildDnsRefreshRate();
    public A withDnsRefreshRate(Duration dnsRefreshRate);
    public Boolean hasDnsRefreshRate();
    public A withNewDnsRefreshRate(Integer nanos,Long seconds);
    public MeshConfigFluent.DnsRefreshRateNested<A> withNewDnsRefreshRate();
    public MeshConfigFluent.DnsRefreshRateNested<A> withNewDnsRefreshRateLike(Duration item);
    public MeshConfigFluent.DnsRefreshRateNested<A> editDnsRefreshRate();
    public MeshConfigFluent.DnsRefreshRateNested<A> editOrNewDnsRefreshRate();
    public MeshConfigFluent.DnsRefreshRateNested<A> editOrNewDnsRefreshRateLike(Duration item);
    public Boolean isEnableAutoMtls();
    public A withEnableAutoMtls(Boolean enableAutoMtls);
    public Boolean hasEnableAutoMtls();
    public A withNewEnableAutoMtls(String arg1);
    public A withNewEnableAutoMtls(boolean arg1);
    public Boolean isEnableClientSidePolicyCheck();
    public A withEnableClientSidePolicyCheck(Boolean enableClientSidePolicyCheck);
    public Boolean hasEnableClientSidePolicyCheck();
    public A withNewEnableClientSidePolicyCheck(String arg1);
    public A withNewEnableClientSidePolicyCheck(boolean arg1);
    public Boolean isEnableEnvoyAccessLogService();
    public A withEnableEnvoyAccessLogService(Boolean enableEnvoyAccessLogService);
    public Boolean hasEnableEnvoyAccessLogService();
    public A withNewEnableEnvoyAccessLogService(String arg1);
    public A withNewEnableEnvoyAccessLogService(boolean arg1);
    public Boolean isEnablePrometheusMerge();
    public A withEnablePrometheusMerge(Boolean enablePrometheusMerge);
    public Boolean hasEnablePrometheusMerge();
    public A withNewEnablePrometheusMerge(String arg1);
    public A withNewEnablePrometheusMerge(boolean arg1);
    public Boolean isEnableSdsTokenMount();
    public A withEnableSdsTokenMount(Boolean enableSdsTokenMount);
    public Boolean hasEnableSdsTokenMount();
    public A withNewEnableSdsTokenMount(String arg1);
    public A withNewEnableSdsTokenMount(boolean arg1);
    public Boolean isEnableTracing();
    public A withEnableTracing(Boolean enableTracing);
    public Boolean hasEnableTracing();
    public A withNewEnableTracing(String arg1);
    public A withNewEnableTracing(boolean arg1);
    public H2UpgradePolicy getH2UpgradePolicy();
    public A withH2UpgradePolicy(H2UpgradePolicy h2UpgradePolicy);
    public Boolean hasH2UpgradePolicy();
    public String getInboundClusterStatName();
    public A withInboundClusterStatName(String inboundClusterStatName);
    public Boolean hasInboundClusterStatName();
    public A withNewInboundClusterStatName(String arg1);
    public A withNewInboundClusterStatName(StringBuilder arg1);
    public A withNewInboundClusterStatName(StringBuffer arg1);
    public String getIngressClass();
    public A withIngressClass(String ingressClass);
    public Boolean hasIngressClass();
    public A withNewIngressClass(String arg1);
    public A withNewIngressClass(StringBuilder arg1);
    public A withNewIngressClass(StringBuffer arg1);
    public IngressControllerMode getIngressControllerMode();
    public A withIngressControllerMode(IngressControllerMode ingressControllerMode);
    public Boolean hasIngressControllerMode();
    public String getIngressSelector();
    public A withIngressSelector(String ingressSelector);
    public Boolean hasIngressSelector();
    public A withNewIngressSelector(String arg1);
    public A withNewIngressSelector(StringBuilder arg1);
    public A withNewIngressSelector(StringBuffer arg1);
    public String getIngressService();
    public A withIngressService(String ingressService);
    public Boolean hasIngressService();
    public A withNewIngressService(String arg1);
    public A withNewIngressService(StringBuilder arg1);
    public A withNewIngressService(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildLocalityLbSetting instead.
 * @return The buildable object.
 */
@Deprecated public LocalityLoadBalancerSetting getLocalityLbSetting();
    public LocalityLoadBalancerSetting buildLocalityLbSetting();
    public A withLocalityLbSetting(LocalityLoadBalancerSetting localityLbSetting);
    public Boolean hasLocalityLbSetting();
    public MeshConfigFluent.LocalityLbSettingNested<A> withNewLocalityLbSetting();
    public MeshConfigFluent.LocalityLbSettingNested<A> withNewLocalityLbSettingLike(LocalityLoadBalancerSetting item);
    public MeshConfigFluent.LocalityLbSettingNested<A> editLocalityLbSetting();
    public MeshConfigFluent.LocalityLbSettingNested<A> editOrNewLocalityLbSetting();
    public MeshConfigFluent.LocalityLbSettingNested<A> editOrNewLocalityLbSettingLike(LocalityLoadBalancerSetting item);
    public String getMixerAddress();
    public A withMixerAddress(String mixerAddress);
    public Boolean hasMixerAddress();
    public A withNewMixerAddress(String arg1);
    public A withNewMixerAddress(StringBuilder arg1);
    public A withNewMixerAddress(StringBuffer arg1);
    public String getMixerCheckServer();
    public A withMixerCheckServer(String mixerCheckServer);
    public Boolean hasMixerCheckServer();
    public A withNewMixerCheckServer(String arg1);
    public A withNewMixerCheckServer(StringBuilder arg1);
    public A withNewMixerCheckServer(StringBuffer arg1);
    public String getMixerReportServer();
    public A withMixerReportServer(String mixerReportServer);
    public Boolean hasMixerReportServer();
    public A withNewMixerReportServer(String arg1);
    public A withNewMixerReportServer(StringBuilder arg1);
    public A withNewMixerReportServer(StringBuffer arg1);
    public String getOutboundClusterStatName();
    public A withOutboundClusterStatName(String outboundClusterStatName);
    public Boolean hasOutboundClusterStatName();
    public A withNewOutboundClusterStatName(String arg1);
    public A withNewOutboundClusterStatName(StringBuilder arg1);
    public A withNewOutboundClusterStatName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildOutboundTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public OutboundTrafficPolicy getOutboundTrafficPolicy();
    public OutboundTrafficPolicy buildOutboundTrafficPolicy();
    public A withOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy);
    public Boolean hasOutboundTrafficPolicy();
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy();
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item);
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy();
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy();
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item);
    public Boolean isPolicyCheckFailOpen();
    public A withPolicyCheckFailOpen(Boolean policyCheckFailOpen);
    public Boolean hasPolicyCheckFailOpen();
    public A withNewPolicyCheckFailOpen(String arg1);
    public A withNewPolicyCheckFailOpen(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildProtocolDetectionTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getProtocolDetectionTimeout();
    public Duration buildProtocolDetectionTimeout();
    public A withProtocolDetectionTimeout(Duration protocolDetectionTimeout);
    public Boolean hasProtocolDetectionTimeout();
    public A withNewProtocolDetectionTimeout(Integer nanos,Long seconds);
    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> withNewProtocolDetectionTimeout();
    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> withNewProtocolDetectionTimeoutLike(Duration item);
    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> editProtocolDetectionTimeout();
    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> editOrNewProtocolDetectionTimeout();
    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> editOrNewProtocolDetectionTimeoutLike(Duration item);
    public Integer getProxyHttpPort();
    public A withProxyHttpPort(Integer proxyHttpPort);
    public Boolean hasProxyHttpPort();
    public Integer getProxyListenPort();
    public A withProxyListenPort(Integer proxyListenPort);
    public Boolean hasProxyListenPort();
    
/**
 * This method has been deprecated, please use method buildRdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getRdsRefreshDelay();
    public Duration buildRdsRefreshDelay();
    public A withRdsRefreshDelay(Duration rdsRefreshDelay);
    public Boolean hasRdsRefreshDelay();
    public A withNewRdsRefreshDelay(Integer nanos,Long seconds);
    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelay();
    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelayLike(Duration item);
    public MeshConfigFluent.RdsRefreshDelayNested<A> editRdsRefreshDelay();
    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelay();
    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelayLike(Duration item);
    public Integer getReportBatchMaxEntries();
    public A withReportBatchMaxEntries(Integer reportBatchMaxEntries);
    public Boolean hasReportBatchMaxEntries();
    
/**
 * This method has been deprecated, please use method buildReportBatchMaxTime instead.
 * @return The buildable object.
 */
@Deprecated public Duration getReportBatchMaxTime();
    public Duration buildReportBatchMaxTime();
    public A withReportBatchMaxTime(Duration reportBatchMaxTime);
    public Boolean hasReportBatchMaxTime();
    public A withNewReportBatchMaxTime(Integer nanos,Long seconds);
    public MeshConfigFluent.ReportBatchMaxTimeNested<A> withNewReportBatchMaxTime();
    public MeshConfigFluent.ReportBatchMaxTimeNested<A> withNewReportBatchMaxTimeLike(Duration item);
    public MeshConfigFluent.ReportBatchMaxTimeNested<A> editReportBatchMaxTime();
    public MeshConfigFluent.ReportBatchMaxTimeNested<A> editOrNewReportBatchMaxTime();
    public MeshConfigFluent.ReportBatchMaxTimeNested<A> editOrNewReportBatchMaxTimeLike(Duration item);
    public String getRootNamespace();
    public A withRootNamespace(String rootNamespace);
    public Boolean hasRootNamespace();
    public A withNewRootNamespace(String arg1);
    public A withNewRootNamespace(StringBuilder arg1);
    public A withNewRootNamespace(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getSdsRefreshDelay();
    public Duration buildSdsRefreshDelay();
    public A withSdsRefreshDelay(Duration sdsRefreshDelay);
    public Boolean hasSdsRefreshDelay();
    public A withNewSdsRefreshDelay(Integer nanos,Long seconds);
    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelay();
    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelayLike(Duration item);
    public MeshConfigFluent.SdsRefreshDelayNested<A> editSdsRefreshDelay();
    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelay();
    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelayLike(Duration item);
    public String getSdsUdsPath();
    public A withSdsUdsPath(String sdsUdsPath);
    public Boolean hasSdsUdsPath();
    public A withNewSdsUdsPath(String arg1);
    public A withNewSdsUdsPath(StringBuilder arg1);
    public A withNewSdsUdsPath(StringBuffer arg1);
    public Boolean isSdsUseK8sSaJwt();
    public A withSdsUseK8sSaJwt(Boolean sdsUseK8sSaJwt);
    public Boolean hasSdsUseK8sSaJwt();
    public A withNewSdsUseK8sSaJwt(String arg1);
    public A withNewSdsUseK8sSaJwt(boolean arg1);
    public A addToServiceSettings(int index,ServiceSettings item);
    public A setToServiceSettings(int index,ServiceSettings item);
    public A addToServiceSettings(ServiceSettings... items);
    public A addAllToServiceSettings(Collection<ServiceSettings> items);
    public A removeFromServiceSettings(ServiceSettings... items);
    public A removeAllFromServiceSettings(Collection<ServiceSettings> items);
    public A removeMatchingFromServiceSettings(io.fabric8.kubernetes.api.builder.Predicate<ServiceSettingsBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildServiceSettings instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceSettings> getServiceSettings();
    public List<ServiceSettings> buildServiceSettings();
    public ServiceSettings buildServiceSetting(int index);
    public ServiceSettings buildFirstServiceSetting();
    public ServiceSettings buildLastServiceSetting();
    public ServiceSettings buildMatchingServiceSetting(io.fabric8.kubernetes.api.builder.Predicate<ServiceSettingsBuilder> predicate);
    public Boolean hasMatchingServiceSetting(io.fabric8.kubernetes.api.builder.Predicate<ServiceSettingsBuilder> predicate);
    public A withServiceSettings(List<ServiceSettings> serviceSettings);
    public A withServiceSettings(ServiceSettings... serviceSettings);
    public Boolean hasServiceSettings();
    public MeshConfigFluent.ServiceSettingsNested<A> addNewServiceSetting();
    public MeshConfigFluent.ServiceSettingsNested<A> addNewServiceSettingLike(ServiceSettings item);
    public MeshConfigFluent.ServiceSettingsNested<A> setNewServiceSettingLike(int index,ServiceSettings item);
    public MeshConfigFluent.ServiceSettingsNested<A> editServiceSetting(int index);
    public MeshConfigFluent.ServiceSettingsNested<A> editFirstServiceSetting();
    public MeshConfigFluent.ServiceSettingsNested<A> editLastServiceSetting();
    public MeshConfigFluent.ServiceSettingsNested<A> editMatchingServiceSetting(io.fabric8.kubernetes.api.builder.Predicate<ServiceSettingsBuilder> predicate);
    public Boolean isSidecarToTelemetrySessionAffinity();
    public A withSidecarToTelemetrySessionAffinity(Boolean sidecarToTelemetrySessionAffinity);
    public Boolean hasSidecarToTelemetrySessionAffinity();
    public A withNewSidecarToTelemetrySessionAffinity(String arg1);
    public A withNewSidecarToTelemetrySessionAffinity(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildTcpKeepalive instead.
 * @return The buildable object.
 */
@Deprecated public TcpKeepalive getTcpKeepalive();
    public TcpKeepalive buildTcpKeepalive();
    public A withTcpKeepalive(TcpKeepalive tcpKeepalive);
    public Boolean hasTcpKeepalive();
    public MeshConfigFluent.TcpKeepaliveNested<A> withNewTcpKeepalive();
    public MeshConfigFluent.TcpKeepaliveNested<A> withNewTcpKeepaliveLike(TcpKeepalive item);
    public MeshConfigFluent.TcpKeepaliveNested<A> editTcpKeepalive();
    public MeshConfigFluent.TcpKeepaliveNested<A> editOrNewTcpKeepalive();
    public MeshConfigFluent.TcpKeepaliveNested<A> editOrNewTcpKeepaliveLike(TcpKeepalive item);
    
/**
 * This method has been deprecated, please use method buildThriftConfig instead.
 * @return The buildable object.
 */
@Deprecated public ThriftConfig getThriftConfig();
    public ThriftConfig buildThriftConfig();
    public A withThriftConfig(ThriftConfig thriftConfig);
    public Boolean hasThriftConfig();
    public MeshConfigFluent.ThriftConfigNested<A> withNewThriftConfig();
    public MeshConfigFluent.ThriftConfigNested<A> withNewThriftConfigLike(ThriftConfig item);
    public MeshConfigFluent.ThriftConfigNested<A> editThriftConfig();
    public MeshConfigFluent.ThriftConfigNested<A> editOrNewThriftConfig();
    public MeshConfigFluent.ThriftConfigNested<A> editOrNewThriftConfigLike(ThriftConfig item);
    public String getTrustDomain();
    public A withTrustDomain(String trustDomain);
    public Boolean hasTrustDomain();
    public A withNewTrustDomain(String arg1);
    public A withNewTrustDomain(StringBuilder arg1);
    public A withNewTrustDomain(StringBuffer arg1);
    public A addToTrustDomainAliases(int index,String item);
    public A setToTrustDomainAliases(int index,String item);
    public A addToTrustDomainAliases(String... items);
    public A addAllToTrustDomainAliases(Collection<String> items);
    public A removeFromTrustDomainAliases(String... items);
    public A removeAllFromTrustDomainAliases(Collection<String> items);
    public List<String> getTrustDomainAliases();
    public String getTrustDomainAlias(int index);
    public String getFirstTrustDomainAlias();
    public String getLastTrustDomainAlias();
    public String getMatchingTrustDomainAlias(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingTrustDomainAlias(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withTrustDomainAliases(List<String> trustDomainAliases);
    public A withTrustDomainAliases(String... trustDomainAliases);
    public Boolean hasTrustDomainAliases();
    public A addNewTrustDomainAlias(String arg1);
    public A addNewTrustDomainAlias(StringBuilder arg1);
    public A addNewTrustDomainAlias(StringBuffer arg1);

    public interface CertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CertificateFluent<MeshConfigFluent.CertificatesNested<N>>{

        
    public N and();    public N endCertificate();
}
    public interface ConfigSourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigSourceFluent<MeshConfigFluent.ConfigSourcesNested<N>>{

        
    public N and();    public N endConfigSource();
}
    public interface ConnectTimeoutNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.ConnectTimeoutNested<N>>{

        
    public N and();    public N endConnectTimeout();
}
    public interface DefaultConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyConfigFluent<MeshConfigFluent.DefaultConfigNested<N>>{

        
    public N and();    public N endDefaultConfig();
}
    public interface DnsRefreshRateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.DnsRefreshRateNested<N>>{

        
    public N and();    public N endDnsRefreshRate();
}
    public interface LocalityLbSettingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalityLoadBalancerSettingFluent<MeshConfigFluent.LocalityLbSettingNested<N>>{

        
    public N and();    public N endLocalityLbSetting();
}
    public interface OutboundTrafficPolicyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OutboundTrafficPolicyFluent<MeshConfigFluent.OutboundTrafficPolicyNested<N>>{

        
    public N and();    public N endOutboundTrafficPolicy();
}
    public interface ProtocolDetectionTimeoutNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.ProtocolDetectionTimeoutNested<N>>{

        
    public N and();    public N endProtocolDetectionTimeout();
}
    public interface RdsRefreshDelayNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.RdsRefreshDelayNested<N>>{

        
    public N and();    public N endRdsRefreshDelay();
}
    public interface ReportBatchMaxTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.ReportBatchMaxTimeNested<N>>{

        
    public N and();    public N endReportBatchMaxTime();
}
    public interface SdsRefreshDelayNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.SdsRefreshDelayNested<N>>{

        
    public N and();    public N endSdsRefreshDelay();
}
    public interface ServiceSettingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceSettingsFluent<MeshConfigFluent.ServiceSettingsNested<N>>{

        
    public N and();    public N endServiceSetting();
}
    public interface TcpKeepaliveNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TcpKeepaliveFluent<MeshConfigFluent.TcpKeepaliveNested<N>>{

        
    public N and();    public N endTcpKeepalive();
}
    public interface ThriftConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ThriftConfigFluent<MeshConfigFluent.ThriftConfigNested<N>>{

        
    public N and();    public N endThriftConfig();
}


}
