package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepalive;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import me.snowdrop.istio.api.networking.v1alpha3.LocalityLoadBalancerSetting;
import me.snowdrop.istio.api.Duration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;
import me.snowdrop.istio.api.DurationFluentImpl;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepaliveFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.Deprecated;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.networking.v1alpha3.LocalityLoadBalancerSettingBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.LocalityLoadBalancerSettingFluentImpl;
import java.lang.Integer;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepaliveBuilder;

public class MeshConfigFluentImpl<A extends MeshConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MeshConfigFluent<A>{

    private AccessLogEncoding accessLogEncoding;
    private String accessLogFile;
    private String accessLogFormat;
    private AuthenticationPolicy authPolicy;
    private List<CertificateBuilder> certificates;
    private List<ConfigSourceBuilder> configSources;
    private DurationBuilder connectTimeout;
    private ProxyConfigBuilder defaultConfig;
    private List<String> defaultDestinationRuleExportTo;
    private List<String> defaultServiceExportTo;
    private List<String> defaultVirtualServiceExportTo;
    private Boolean disableMixerHttpReports;
    private Boolean disablePolicyChecks;
    private Boolean disableReportBatch;
    private DurationBuilder dnsRefreshRate;
    private Boolean enableAutoMtls;
    private Boolean enableClientSidePolicyCheck;
    private Boolean enableEnvoyAccessLogService;
    private Boolean enablePrometheusMerge;
    private Boolean enableSdsTokenMount;
    private Boolean enableTracing;
    private H2UpgradePolicy h2UpgradePolicy;
    private String inboundClusterStatName;
    private String ingressClass;
    private IngressControllerMode ingressControllerMode;
    private String ingressSelector;
    private String ingressService;
    private LocalityLoadBalancerSettingBuilder localityLbSetting;
    private String mixerAddress;
    private String mixerCheckServer;
    private String mixerReportServer;
    private String outboundClusterStatName;
    private OutboundTrafficPolicyBuilder outboundTrafficPolicy;
    private Boolean policyCheckFailOpen;
    private DurationBuilder protocolDetectionTimeout;
    private Integer proxyHttpPort;
    private Integer proxyListenPort;
    private DurationBuilder rdsRefreshDelay;
    private Integer reportBatchMaxEntries;
    private DurationBuilder reportBatchMaxTime;
    private String rootNamespace;
    private DurationBuilder sdsRefreshDelay;
    private String sdsUdsPath;
    private Boolean sdsUseK8sSaJwt;
    private List<ServiceSettingsBuilder> serviceSettings;
    private Boolean sidecarToTelemetrySessionAffinity;
    private TcpKeepaliveBuilder tcpKeepalive;
    private ThriftConfigBuilder thriftConfig;
    private String trustDomain;
    private List<String> trustDomainAliases;

    public MeshConfigFluentImpl(){
    }
    public MeshConfigFluentImpl(MeshConfig instance){
            this.withAccessLogEncoding(instance.getAccessLogEncoding()); 
            this.withAccessLogFile(instance.getAccessLogFile()); 
            this.withAccessLogFormat(instance.getAccessLogFormat()); 
            this.withAuthPolicy(instance.getAuthPolicy()); 
            this.withCertificates(instance.getCertificates()); 
            this.withConfigSources(instance.getConfigSources()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withDefaultConfig(instance.getDefaultConfig()); 
            this.withDefaultDestinationRuleExportTo(instance.getDefaultDestinationRuleExportTo()); 
            this.withDefaultServiceExportTo(instance.getDefaultServiceExportTo()); 
            this.withDefaultVirtualServiceExportTo(instance.getDefaultVirtualServiceExportTo()); 
            this.withDisableMixerHttpReports(instance.getDisableMixerHttpReports()); 
            this.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            this.withDisableReportBatch(instance.getDisableReportBatch()); 
            this.withDnsRefreshRate(instance.getDnsRefreshRate()); 
            this.withEnableAutoMtls(instance.getEnableAutoMtls()); 
            this.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            this.withEnableEnvoyAccessLogService(instance.getEnableEnvoyAccessLogService()); 
            this.withEnablePrometheusMerge(instance.getEnablePrometheusMerge()); 
            this.withEnableSdsTokenMount(instance.getEnableSdsTokenMount()); 
            this.withEnableTracing(instance.getEnableTracing()); 
            this.withH2UpgradePolicy(instance.getH2UpgradePolicy()); 
            this.withInboundClusterStatName(instance.getInboundClusterStatName()); 
            this.withIngressClass(instance.getIngressClass()); 
            this.withIngressControllerMode(instance.getIngressControllerMode()); 
            this.withIngressSelector(instance.getIngressSelector()); 
            this.withIngressService(instance.getIngressService()); 
            this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            this.withMixerAddress(instance.getMixerAddress()); 
            this.withMixerCheckServer(instance.getMixerCheckServer()); 
            this.withMixerReportServer(instance.getMixerReportServer()); 
            this.withOutboundClusterStatName(instance.getOutboundClusterStatName()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            this.withProtocolDetectionTimeout(instance.getProtocolDetectionTimeout()); 
            this.withProxyHttpPort(instance.getProxyHttpPort()); 
            this.withProxyListenPort(instance.getProxyListenPort()); 
            this.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            this.withReportBatchMaxEntries(instance.getReportBatchMaxEntries()); 
            this.withReportBatchMaxTime(instance.getReportBatchMaxTime()); 
            this.withRootNamespace(instance.getRootNamespace()); 
            this.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            this.withSdsUdsPath(instance.getSdsUdsPath()); 
            this.withSdsUseK8sSaJwt(instance.getSdsUseK8sSaJwt()); 
            this.withServiceSettings(instance.getServiceSettings()); 
            this.withSidecarToTelemetrySessionAffinity(instance.getSidecarToTelemetrySessionAffinity()); 
            this.withTcpKeepalive(instance.getTcpKeepalive()); 
            this.withThriftConfig(instance.getThriftConfig()); 
            this.withTrustDomain(instance.getTrustDomain()); 
            this.withTrustDomainAliases(instance.getTrustDomainAliases()); 
    }

    public AccessLogEncoding getAccessLogEncoding(){
            return this.accessLogEncoding;
    }

    public A withAccessLogEncoding(AccessLogEncoding accessLogEncoding){
            this.accessLogEncoding=accessLogEncoding; return (A) this;
    }

    public Boolean hasAccessLogEncoding(){
            return this.accessLogEncoding != null;
    }

    public String getAccessLogFile(){
            return this.accessLogFile;
    }

    public A withAccessLogFile(String accessLogFile){
            this.accessLogFile=accessLogFile; return (A) this;
    }

    public Boolean hasAccessLogFile(){
            return this.accessLogFile != null;
    }

    public A withNewAccessLogFile(String arg1){
            return (A)withAccessLogFile(new String(arg1));
    }

    public A withNewAccessLogFile(StringBuilder arg1){
            return (A)withAccessLogFile(new String(arg1));
    }

    public A withNewAccessLogFile(StringBuffer arg1){
            return (A)withAccessLogFile(new String(arg1));
    }

    public String getAccessLogFormat(){
            return this.accessLogFormat;
    }

    public A withAccessLogFormat(String accessLogFormat){
            this.accessLogFormat=accessLogFormat; return (A) this;
    }

    public Boolean hasAccessLogFormat(){
            return this.accessLogFormat != null;
    }

    public A withNewAccessLogFormat(String arg1){
            return (A)withAccessLogFormat(new String(arg1));
    }

    public A withNewAccessLogFormat(StringBuilder arg1){
            return (A)withAccessLogFormat(new String(arg1));
    }

    public A withNewAccessLogFormat(StringBuffer arg1){
            return (A)withAccessLogFormat(new String(arg1));
    }

    public AuthenticationPolicy getAuthPolicy(){
            return this.authPolicy;
    }

    public A withAuthPolicy(AuthenticationPolicy authPolicy){
            this.authPolicy=authPolicy; return (A) this;
    }

    public Boolean hasAuthPolicy(){
            return this.authPolicy != null;
    }

    public A addToCertificates(int index,Certificate item){
            if (this.certificates == null) {this.certificates = new ArrayList<CertificateBuilder>();}
            CertificateBuilder builder = new CertificateBuilder(item);_visitables.get("certificates").add(index >= 0 ? index : _visitables.get("certificates").size(), builder);this.certificates.add(index >= 0 ? index : certificates.size(), builder); return (A)this;
    }

    public A setToCertificates(int index,Certificate item){
            if (this.certificates == null) {this.certificates = new ArrayList<CertificateBuilder>();}
            CertificateBuilder builder = new CertificateBuilder(item);
            if (index < 0 || index >= _visitables.get("certificates").size()) { _visitables.get("certificates").add(builder); } else { _visitables.get("certificates").set(index, builder);}
            if (index < 0 || index >= certificates.size()) { certificates.add(builder); } else { certificates.set(index, builder);}
             return (A)this;
    }

    public A addToCertificates(Certificate... items){
            if (this.certificates == null) {this.certificates = new ArrayList<CertificateBuilder>();}
            for (Certificate item : items) {CertificateBuilder builder = new CertificateBuilder(item);_visitables.get("certificates").add(builder);this.certificates.add(builder);} return (A)this;
    }

    public A addAllToCertificates(Collection<Certificate> items){
            if (this.certificates == null) {this.certificates = new ArrayList<CertificateBuilder>();}
            for (Certificate item : items) {CertificateBuilder builder = new CertificateBuilder(item);_visitables.get("certificates").add(builder);this.certificates.add(builder);} return (A)this;
    }

    public A removeFromCertificates(Certificate... items){
            for (Certificate item : items) {CertificateBuilder builder = new CertificateBuilder(item);_visitables.get("certificates").remove(builder);if (this.certificates != null) {this.certificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromCertificates(Collection<Certificate> items){
            for (Certificate item : items) {CertificateBuilder builder = new CertificateBuilder(item);_visitables.get("certificates").remove(builder);if (this.certificates != null) {this.certificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromCertificates(io.fabric8.kubernetes.api.builder.Predicate<CertificateBuilder> predicate){
            if (certificates == null) return (A) this;
            final Iterator<CertificateBuilder> each = certificates.iterator();
            final List visitables = _visitables.get("certificates");
            while (each.hasNext()) {
              CertificateBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildCertificates instead.
 * @return The buildable object.
 */
@Deprecated public List<Certificate> getCertificates(){
            return build(certificates);
    }

    public List<Certificate> buildCertificates(){
            return build(certificates);
    }

    public Certificate buildCertificate(int index){
            return this.certificates.get(index).build();
    }

    public Certificate buildFirstCertificate(){
            return this.certificates.get(0).build();
    }

    public Certificate buildLastCertificate(){
            return this.certificates.get(certificates.size() - 1).build();
    }

    public Certificate buildMatchingCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertificateBuilder> predicate){
            for (CertificateBuilder item: certificates) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertificateBuilder> predicate){
            for (CertificateBuilder item: certificates) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withCertificates(List<Certificate> certificates){
            if (this.certificates != null) { _visitables.get("certificates").removeAll(this.certificates);}
            if (certificates != null) {this.certificates = new ArrayList<CertificateBuilder>(); for (Certificate item : certificates){this.addToCertificates(item);}} else { this.certificates = null;} return (A) this;
    }

    public A withCertificates(Certificate... certificates){
            if (this.certificates != null) {this.certificates.clear();}
            if (certificates != null) {for (Certificate item :certificates){ this.addToCertificates(item);}} return (A) this;
    }

    public Boolean hasCertificates(){
            return certificates != null && !certificates.isEmpty();
    }

    public MeshConfigFluent.CertificatesNested<A> addNewCertificate(){
            return new CertificatesNestedImpl();
    }

    public MeshConfigFluent.CertificatesNested<A> addNewCertificateLike(Certificate item){
            return new CertificatesNestedImpl(-1, item);
    }

    public MeshConfigFluent.CertificatesNested<A> setNewCertificateLike(int index,Certificate item){
            return new CertificatesNestedImpl(index, item);
    }

    public MeshConfigFluent.CertificatesNested<A> editCertificate(int index){
            if (certificates.size() <= index) throw new RuntimeException("Can't edit certificates. Index exceeds size.");
            return setNewCertificateLike(index, buildCertificate(index));
    }

    public MeshConfigFluent.CertificatesNested<A> editFirstCertificate(){
            if (certificates.size() == 0) throw new RuntimeException("Can't edit first certificates. The list is empty.");
            return setNewCertificateLike(0, buildCertificate(0));
    }

    public MeshConfigFluent.CertificatesNested<A> editLastCertificate(){
            int index = certificates.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last certificates. The list is empty.");
            return setNewCertificateLike(index, buildCertificate(index));
    }

    public MeshConfigFluent.CertificatesNested<A> editMatchingCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertificateBuilder> predicate){
            int index = -1;
            for (int i=0;i<certificates.size();i++) { 
            if (predicate.apply(certificates.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching certificates. No match found.");
            return setNewCertificateLike(index, buildCertificate(index));
    }

    public A addToConfigSources(int index,ConfigSource item){
            if (this.configSources == null) {this.configSources = new ArrayList<ConfigSourceBuilder>();}
            ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").add(index >= 0 ? index : _visitables.get("configSources").size(), builder);this.configSources.add(index >= 0 ? index : configSources.size(), builder); return (A)this;
    }

    public A setToConfigSources(int index,ConfigSource item){
            if (this.configSources == null) {this.configSources = new ArrayList<ConfigSourceBuilder>();}
            ConfigSourceBuilder builder = new ConfigSourceBuilder(item);
            if (index < 0 || index >= _visitables.get("configSources").size()) { _visitables.get("configSources").add(builder); } else { _visitables.get("configSources").set(index, builder);}
            if (index < 0 || index >= configSources.size()) { configSources.add(builder); } else { configSources.set(index, builder);}
             return (A)this;
    }

    public A addToConfigSources(ConfigSource... items){
            if (this.configSources == null) {this.configSources = new ArrayList<ConfigSourceBuilder>();}
            for (ConfigSource item : items) {ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").add(builder);this.configSources.add(builder);} return (A)this;
    }

    public A addAllToConfigSources(Collection<ConfigSource> items){
            if (this.configSources == null) {this.configSources = new ArrayList<ConfigSourceBuilder>();}
            for (ConfigSource item : items) {ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").add(builder);this.configSources.add(builder);} return (A)this;
    }

    public A removeFromConfigSources(ConfigSource... items){
            for (ConfigSource item : items) {ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").remove(builder);if (this.configSources != null) {this.configSources.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfigSources(Collection<ConfigSource> items){
            for (ConfigSource item : items) {ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").remove(builder);if (this.configSources != null) {this.configSources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfigSources(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate){
            if (configSources == null) return (A) this;
            final Iterator<ConfigSourceBuilder> each = configSources.iterator();
            final List visitables = _visitables.get("configSources");
            while (each.hasNext()) {
              ConfigSourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConfigSources instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigSource> getConfigSources(){
            return build(configSources);
    }

    public List<ConfigSource> buildConfigSources(){
            return build(configSources);
    }

    public ConfigSource buildConfigSource(int index){
            return this.configSources.get(index).build();
    }

    public ConfigSource buildFirstConfigSource(){
            return this.configSources.get(0).build();
    }

    public ConfigSource buildLastConfigSource(){
            return this.configSources.get(configSources.size() - 1).build();
    }

    public ConfigSource buildMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate){
            for (ConfigSourceBuilder item: configSources) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate){
            for (ConfigSourceBuilder item: configSources) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConfigSources(List<ConfigSource> configSources){
            if (this.configSources != null) { _visitables.get("configSources").removeAll(this.configSources);}
            if (configSources != null) {this.configSources = new ArrayList<ConfigSourceBuilder>(); for (ConfigSource item : configSources){this.addToConfigSources(item);}} else { this.configSources = null;} return (A) this;
    }

    public A withConfigSources(ConfigSource... configSources){
            if (this.configSources != null) {this.configSources.clear();}
            if (configSources != null) {for (ConfigSource item :configSources){ this.addToConfigSources(item);}} return (A) this;
    }

    public Boolean hasConfigSources(){
            return configSources != null && !configSources.isEmpty();
    }

    public MeshConfigFluent.ConfigSourcesNested<A> addNewConfigSource(){
            return new ConfigSourcesNestedImpl();
    }

    public MeshConfigFluent.ConfigSourcesNested<A> addNewConfigSourceLike(ConfigSource item){
            return new ConfigSourcesNestedImpl(-1, item);
    }

    public MeshConfigFluent.ConfigSourcesNested<A> setNewConfigSourceLike(int index,ConfigSource item){
            return new ConfigSourcesNestedImpl(index, item);
    }

    public MeshConfigFluent.ConfigSourcesNested<A> editConfigSource(int index){
            if (configSources.size() <= index) throw new RuntimeException("Can't edit configSources. Index exceeds size.");
            return setNewConfigSourceLike(index, buildConfigSource(index));
    }

    public MeshConfigFluent.ConfigSourcesNested<A> editFirstConfigSource(){
            if (configSources.size() == 0) throw new RuntimeException("Can't edit first configSources. The list is empty.");
            return setNewConfigSourceLike(0, buildConfigSource(0));
    }

    public MeshConfigFluent.ConfigSourcesNested<A> editLastConfigSource(){
            int index = configSources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last configSources. The list is empty.");
            return setNewConfigSourceLike(index, buildConfigSource(index));
    }

    public MeshConfigFluent.ConfigSourcesNested<A> editMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<configSources.size();i++) { 
            if (predicate.apply(configSources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching configSources. No match found.");
            return setNewConfigSourceLike(index, buildConfigSource(index));
    }

    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public Duration buildConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public A withConnectTimeout(Duration connectTimeout){
            _visitables.get("connectTimeout").remove(this.connectTimeout);
            if (connectTimeout!=null){ this.connectTimeout= new DurationBuilder(connectTimeout); _visitables.get("connectTimeout").add(this.connectTimeout);} return (A) this;
    }

    public Boolean hasConnectTimeout(){
            return this.connectTimeout != null;
    }

    public A withNewConnectTimeout(Integer nanos,Long seconds){
            return (A)withConnectTimeout(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeout(){
            return new ConnectTimeoutNestedImpl();
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item){
            return new ConnectTimeoutNestedImpl(item);
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout());
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): new DurationBuilder().build());
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDefaultConfig instead.
 * @return The buildable object.
 */
@Deprecated public ProxyConfig getDefaultConfig(){
            return this.defaultConfig!=null?this.defaultConfig.build():null;
    }

    public ProxyConfig buildDefaultConfig(){
            return this.defaultConfig!=null?this.defaultConfig.build():null;
    }

    public A withDefaultConfig(ProxyConfig defaultConfig){
            _visitables.get("defaultConfig").remove(this.defaultConfig);
            if (defaultConfig!=null){ this.defaultConfig= new ProxyConfigBuilder(defaultConfig); _visitables.get("defaultConfig").add(this.defaultConfig);} return (A) this;
    }

    public Boolean hasDefaultConfig(){
            return this.defaultConfig != null;
    }

    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfig(){
            return new DefaultConfigNestedImpl();
    }

    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfigLike(ProxyConfig item){
            return new DefaultConfigNestedImpl(item);
    }

    public MeshConfigFluent.DefaultConfigNested<A> editDefaultConfig(){
            return withNewDefaultConfigLike(getDefaultConfig());
    }

    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfig(){
            return withNewDefaultConfigLike(getDefaultConfig() != null ? getDefaultConfig(): new ProxyConfigBuilder().build());
    }

    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfigLike(ProxyConfig item){
            return withNewDefaultConfigLike(getDefaultConfig() != null ? getDefaultConfig(): item);
    }

    public A addToDefaultDestinationRuleExportTo(int index,String item){
            if (this.defaultDestinationRuleExportTo == null) {this.defaultDestinationRuleExportTo = new ArrayList<String>();}
            this.defaultDestinationRuleExportTo.add(index, item);
            return (A)this;
    }

    public A setToDefaultDestinationRuleExportTo(int index,String item){
            if (this.defaultDestinationRuleExportTo == null) {this.defaultDestinationRuleExportTo = new ArrayList<String>();}
            this.defaultDestinationRuleExportTo.set(index, item); return (A)this;
    }

    public A addToDefaultDestinationRuleExportTo(String... items){
            if (this.defaultDestinationRuleExportTo == null) {this.defaultDestinationRuleExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultDestinationRuleExportTo.add(item);} return (A)this;
    }

    public A addAllToDefaultDestinationRuleExportTo(Collection<String> items){
            if (this.defaultDestinationRuleExportTo == null) {this.defaultDestinationRuleExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultDestinationRuleExportTo.add(item);} return (A)this;
    }

    public A removeFromDefaultDestinationRuleExportTo(String... items){
            for (String item : items) {if (this.defaultDestinationRuleExportTo!= null){ this.defaultDestinationRuleExportTo.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultDestinationRuleExportTo(Collection<String> items){
            for (String item : items) {if (this.defaultDestinationRuleExportTo!= null){ this.defaultDestinationRuleExportTo.remove(item);}} return (A)this;
    }

    public List<String> getDefaultDestinationRuleExportTo(){
            return this.defaultDestinationRuleExportTo;
    }

    public String getDefaultDestinationRuleExportTo(int index){
            return this.defaultDestinationRuleExportTo.get(index);
    }

    public String getFirstDefaultDestinationRuleExportTo(){
            return this.defaultDestinationRuleExportTo.get(0);
    }

    public String getLastDefaultDestinationRuleExportTo(){
            return this.defaultDestinationRuleExportTo.get(defaultDestinationRuleExportTo.size() - 1);
    }

    public String getMatchingDefaultDestinationRuleExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultDestinationRuleExportTo) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDefaultDestinationRuleExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultDestinationRuleExportTo) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDefaultDestinationRuleExportTo(List<String> defaultDestinationRuleExportTo){
            if (this.defaultDestinationRuleExportTo != null) { _visitables.get("defaultDestinationRuleExportTo").removeAll(this.defaultDestinationRuleExportTo);}
            if (defaultDestinationRuleExportTo != null) {this.defaultDestinationRuleExportTo = new ArrayList<String>(); for (String item : defaultDestinationRuleExportTo){this.addToDefaultDestinationRuleExportTo(item);}} else { this.defaultDestinationRuleExportTo = null;} return (A) this;
    }

    public A withDefaultDestinationRuleExportTo(String... defaultDestinationRuleExportTo){
            if (this.defaultDestinationRuleExportTo != null) {this.defaultDestinationRuleExportTo.clear();}
            if (defaultDestinationRuleExportTo != null) {for (String item :defaultDestinationRuleExportTo){ this.addToDefaultDestinationRuleExportTo(item);}} return (A) this;
    }

    public Boolean hasDefaultDestinationRuleExportTo(){
            return defaultDestinationRuleExportTo != null && !defaultDestinationRuleExportTo.isEmpty();
    }

    public A addNewDefaultDestinationRuleExportTo(String arg1){
            return (A)addToDefaultDestinationRuleExportTo(new String(arg1));
    }

    public A addNewDefaultDestinationRuleExportTo(StringBuilder arg1){
            return (A)addToDefaultDestinationRuleExportTo(new String(arg1));
    }

    public A addNewDefaultDestinationRuleExportTo(StringBuffer arg1){
            return (A)addToDefaultDestinationRuleExportTo(new String(arg1));
    }

    public A addToDefaultServiceExportTo(int index,String item){
            if (this.defaultServiceExportTo == null) {this.defaultServiceExportTo = new ArrayList<String>();}
            this.defaultServiceExportTo.add(index, item);
            return (A)this;
    }

    public A setToDefaultServiceExportTo(int index,String item){
            if (this.defaultServiceExportTo == null) {this.defaultServiceExportTo = new ArrayList<String>();}
            this.defaultServiceExportTo.set(index, item); return (A)this;
    }

    public A addToDefaultServiceExportTo(String... items){
            if (this.defaultServiceExportTo == null) {this.defaultServiceExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultServiceExportTo.add(item);} return (A)this;
    }

    public A addAllToDefaultServiceExportTo(Collection<String> items){
            if (this.defaultServiceExportTo == null) {this.defaultServiceExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultServiceExportTo.add(item);} return (A)this;
    }

    public A removeFromDefaultServiceExportTo(String... items){
            for (String item : items) {if (this.defaultServiceExportTo!= null){ this.defaultServiceExportTo.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultServiceExportTo(Collection<String> items){
            for (String item : items) {if (this.defaultServiceExportTo!= null){ this.defaultServiceExportTo.remove(item);}} return (A)this;
    }

    public List<String> getDefaultServiceExportTo(){
            return this.defaultServiceExportTo;
    }

    public String getDefaultServiceExportTo(int index){
            return this.defaultServiceExportTo.get(index);
    }

    public String getFirstDefaultServiceExportTo(){
            return this.defaultServiceExportTo.get(0);
    }

    public String getLastDefaultServiceExportTo(){
            return this.defaultServiceExportTo.get(defaultServiceExportTo.size() - 1);
    }

    public String getMatchingDefaultServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultServiceExportTo) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDefaultServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultServiceExportTo) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDefaultServiceExportTo(List<String> defaultServiceExportTo){
            if (this.defaultServiceExportTo != null) { _visitables.get("defaultServiceExportTo").removeAll(this.defaultServiceExportTo);}
            if (defaultServiceExportTo != null) {this.defaultServiceExportTo = new ArrayList<String>(); for (String item : defaultServiceExportTo){this.addToDefaultServiceExportTo(item);}} else { this.defaultServiceExportTo = null;} return (A) this;
    }

    public A withDefaultServiceExportTo(String... defaultServiceExportTo){
            if (this.defaultServiceExportTo != null) {this.defaultServiceExportTo.clear();}
            if (defaultServiceExportTo != null) {for (String item :defaultServiceExportTo){ this.addToDefaultServiceExportTo(item);}} return (A) this;
    }

    public Boolean hasDefaultServiceExportTo(){
            return defaultServiceExportTo != null && !defaultServiceExportTo.isEmpty();
    }

    public A addNewDefaultServiceExportTo(String arg1){
            return (A)addToDefaultServiceExportTo(new String(arg1));
    }

    public A addNewDefaultServiceExportTo(StringBuilder arg1){
            return (A)addToDefaultServiceExportTo(new String(arg1));
    }

    public A addNewDefaultServiceExportTo(StringBuffer arg1){
            return (A)addToDefaultServiceExportTo(new String(arg1));
    }

    public A addToDefaultVirtualServiceExportTo(int index,String item){
            if (this.defaultVirtualServiceExportTo == null) {this.defaultVirtualServiceExportTo = new ArrayList<String>();}
            this.defaultVirtualServiceExportTo.add(index, item);
            return (A)this;
    }

    public A setToDefaultVirtualServiceExportTo(int index,String item){
            if (this.defaultVirtualServiceExportTo == null) {this.defaultVirtualServiceExportTo = new ArrayList<String>();}
            this.defaultVirtualServiceExportTo.set(index, item); return (A)this;
    }

    public A addToDefaultVirtualServiceExportTo(String... items){
            if (this.defaultVirtualServiceExportTo == null) {this.defaultVirtualServiceExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultVirtualServiceExportTo.add(item);} return (A)this;
    }

    public A addAllToDefaultVirtualServiceExportTo(Collection<String> items){
            if (this.defaultVirtualServiceExportTo == null) {this.defaultVirtualServiceExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultVirtualServiceExportTo.add(item);} return (A)this;
    }

    public A removeFromDefaultVirtualServiceExportTo(String... items){
            for (String item : items) {if (this.defaultVirtualServiceExportTo!= null){ this.defaultVirtualServiceExportTo.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultVirtualServiceExportTo(Collection<String> items){
            for (String item : items) {if (this.defaultVirtualServiceExportTo!= null){ this.defaultVirtualServiceExportTo.remove(item);}} return (A)this;
    }

    public List<String> getDefaultVirtualServiceExportTo(){
            return this.defaultVirtualServiceExportTo;
    }

    public String getDefaultVirtualServiceExportTo(int index){
            return this.defaultVirtualServiceExportTo.get(index);
    }

    public String getFirstDefaultVirtualServiceExportTo(){
            return this.defaultVirtualServiceExportTo.get(0);
    }

    public String getLastDefaultVirtualServiceExportTo(){
            return this.defaultVirtualServiceExportTo.get(defaultVirtualServiceExportTo.size() - 1);
    }

    public String getMatchingDefaultVirtualServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultVirtualServiceExportTo) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDefaultVirtualServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultVirtualServiceExportTo) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDefaultVirtualServiceExportTo(List<String> defaultVirtualServiceExportTo){
            if (this.defaultVirtualServiceExportTo != null) { _visitables.get("defaultVirtualServiceExportTo").removeAll(this.defaultVirtualServiceExportTo);}
            if (defaultVirtualServiceExportTo != null) {this.defaultVirtualServiceExportTo = new ArrayList<String>(); for (String item : defaultVirtualServiceExportTo){this.addToDefaultVirtualServiceExportTo(item);}} else { this.defaultVirtualServiceExportTo = null;} return (A) this;
    }

    public A withDefaultVirtualServiceExportTo(String... defaultVirtualServiceExportTo){
            if (this.defaultVirtualServiceExportTo != null) {this.defaultVirtualServiceExportTo.clear();}
            if (defaultVirtualServiceExportTo != null) {for (String item :defaultVirtualServiceExportTo){ this.addToDefaultVirtualServiceExportTo(item);}} return (A) this;
    }

    public Boolean hasDefaultVirtualServiceExportTo(){
            return defaultVirtualServiceExportTo != null && !defaultVirtualServiceExportTo.isEmpty();
    }

    public A addNewDefaultVirtualServiceExportTo(String arg1){
            return (A)addToDefaultVirtualServiceExportTo(new String(arg1));
    }

    public A addNewDefaultVirtualServiceExportTo(StringBuilder arg1){
            return (A)addToDefaultVirtualServiceExportTo(new String(arg1));
    }

    public A addNewDefaultVirtualServiceExportTo(StringBuffer arg1){
            return (A)addToDefaultVirtualServiceExportTo(new String(arg1));
    }

    public Boolean isDisableMixerHttpReports(){
            return this.disableMixerHttpReports;
    }

    public A withDisableMixerHttpReports(Boolean disableMixerHttpReports){
            this.disableMixerHttpReports=disableMixerHttpReports; return (A) this;
    }

    public Boolean hasDisableMixerHttpReports(){
            return this.disableMixerHttpReports != null;
    }

    public A withNewDisableMixerHttpReports(String arg1){
            return (A)withDisableMixerHttpReports(new Boolean(arg1));
    }

    public A withNewDisableMixerHttpReports(boolean arg1){
            return (A)withDisableMixerHttpReports(new Boolean(arg1));
    }

    public Boolean isDisablePolicyChecks(){
            return this.disablePolicyChecks;
    }

    public A withDisablePolicyChecks(Boolean disablePolicyChecks){
            this.disablePolicyChecks=disablePolicyChecks; return (A) this;
    }

    public Boolean hasDisablePolicyChecks(){
            return this.disablePolicyChecks != null;
    }

    public A withNewDisablePolicyChecks(String arg1){
            return (A)withDisablePolicyChecks(new Boolean(arg1));
    }

    public A withNewDisablePolicyChecks(boolean arg1){
            return (A)withDisablePolicyChecks(new Boolean(arg1));
    }

    public Boolean isDisableReportBatch(){
            return this.disableReportBatch;
    }

    public A withDisableReportBatch(Boolean disableReportBatch){
            this.disableReportBatch=disableReportBatch; return (A) this;
    }

    public Boolean hasDisableReportBatch(){
            return this.disableReportBatch != null;
    }

    public A withNewDisableReportBatch(String arg1){
            return (A)withDisableReportBatch(new Boolean(arg1));
    }

    public A withNewDisableReportBatch(boolean arg1){
            return (A)withDisableReportBatch(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDnsRefreshRate instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDnsRefreshRate(){
            return this.dnsRefreshRate!=null?this.dnsRefreshRate.build():null;
    }

    public Duration buildDnsRefreshRate(){
            return this.dnsRefreshRate!=null?this.dnsRefreshRate.build():null;
    }

    public A withDnsRefreshRate(Duration dnsRefreshRate){
            _visitables.get("dnsRefreshRate").remove(this.dnsRefreshRate);
            if (dnsRefreshRate!=null){ this.dnsRefreshRate= new DurationBuilder(dnsRefreshRate); _visitables.get("dnsRefreshRate").add(this.dnsRefreshRate);} return (A) this;
    }

    public Boolean hasDnsRefreshRate(){
            return this.dnsRefreshRate != null;
    }

    public A withNewDnsRefreshRate(Integer nanos,Long seconds){
            return (A)withDnsRefreshRate(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> withNewDnsRefreshRate(){
            return new DnsRefreshRateNestedImpl();
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> withNewDnsRefreshRateLike(Duration item){
            return new DnsRefreshRateNestedImpl(item);
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> editDnsRefreshRate(){
            return withNewDnsRefreshRateLike(getDnsRefreshRate());
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> editOrNewDnsRefreshRate(){
            return withNewDnsRefreshRateLike(getDnsRefreshRate() != null ? getDnsRefreshRate(): new DurationBuilder().build());
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> editOrNewDnsRefreshRateLike(Duration item){
            return withNewDnsRefreshRateLike(getDnsRefreshRate() != null ? getDnsRefreshRate(): item);
    }

    public Boolean isEnableAutoMtls(){
            return this.enableAutoMtls;
    }

    public A withEnableAutoMtls(Boolean enableAutoMtls){
            this.enableAutoMtls=enableAutoMtls; return (A) this;
    }

    public Boolean hasEnableAutoMtls(){
            return this.enableAutoMtls != null;
    }

    public A withNewEnableAutoMtls(String arg1){
            return (A)withEnableAutoMtls(new Boolean(arg1));
    }

    public A withNewEnableAutoMtls(boolean arg1){
            return (A)withEnableAutoMtls(new Boolean(arg1));
    }

    public Boolean isEnableClientSidePolicyCheck(){
            return this.enableClientSidePolicyCheck;
    }

    public A withEnableClientSidePolicyCheck(Boolean enableClientSidePolicyCheck){
            this.enableClientSidePolicyCheck=enableClientSidePolicyCheck; return (A) this;
    }

    public Boolean hasEnableClientSidePolicyCheck(){
            return this.enableClientSidePolicyCheck != null;
    }

    public A withNewEnableClientSidePolicyCheck(String arg1){
            return (A)withEnableClientSidePolicyCheck(new Boolean(arg1));
    }

    public A withNewEnableClientSidePolicyCheck(boolean arg1){
            return (A)withEnableClientSidePolicyCheck(new Boolean(arg1));
    }

    public Boolean isEnableEnvoyAccessLogService(){
            return this.enableEnvoyAccessLogService;
    }

    public A withEnableEnvoyAccessLogService(Boolean enableEnvoyAccessLogService){
            this.enableEnvoyAccessLogService=enableEnvoyAccessLogService; return (A) this;
    }

    public Boolean hasEnableEnvoyAccessLogService(){
            return this.enableEnvoyAccessLogService != null;
    }

    public A withNewEnableEnvoyAccessLogService(String arg1){
            return (A)withEnableEnvoyAccessLogService(new Boolean(arg1));
    }

    public A withNewEnableEnvoyAccessLogService(boolean arg1){
            return (A)withEnableEnvoyAccessLogService(new Boolean(arg1));
    }

    public Boolean isEnablePrometheusMerge(){
            return this.enablePrometheusMerge;
    }

    public A withEnablePrometheusMerge(Boolean enablePrometheusMerge){
            this.enablePrometheusMerge=enablePrometheusMerge; return (A) this;
    }

    public Boolean hasEnablePrometheusMerge(){
            return this.enablePrometheusMerge != null;
    }

    public A withNewEnablePrometheusMerge(String arg1){
            return (A)withEnablePrometheusMerge(new Boolean(arg1));
    }

    public A withNewEnablePrometheusMerge(boolean arg1){
            return (A)withEnablePrometheusMerge(new Boolean(arg1));
    }

    public Boolean isEnableSdsTokenMount(){
            return this.enableSdsTokenMount;
    }

    public A withEnableSdsTokenMount(Boolean enableSdsTokenMount){
            this.enableSdsTokenMount=enableSdsTokenMount; return (A) this;
    }

    public Boolean hasEnableSdsTokenMount(){
            return this.enableSdsTokenMount != null;
    }

    public A withNewEnableSdsTokenMount(String arg1){
            return (A)withEnableSdsTokenMount(new Boolean(arg1));
    }

    public A withNewEnableSdsTokenMount(boolean arg1){
            return (A)withEnableSdsTokenMount(new Boolean(arg1));
    }

    public Boolean isEnableTracing(){
            return this.enableTracing;
    }

    public A withEnableTracing(Boolean enableTracing){
            this.enableTracing=enableTracing; return (A) this;
    }

    public Boolean hasEnableTracing(){
            return this.enableTracing != null;
    }

    public A withNewEnableTracing(String arg1){
            return (A)withEnableTracing(new Boolean(arg1));
    }

    public A withNewEnableTracing(boolean arg1){
            return (A)withEnableTracing(new Boolean(arg1));
    }

    public H2UpgradePolicy getH2UpgradePolicy(){
            return this.h2UpgradePolicy;
    }

    public A withH2UpgradePolicy(H2UpgradePolicy h2UpgradePolicy){
            this.h2UpgradePolicy=h2UpgradePolicy; return (A) this;
    }

    public Boolean hasH2UpgradePolicy(){
            return this.h2UpgradePolicy != null;
    }

    public String getInboundClusterStatName(){
            return this.inboundClusterStatName;
    }

    public A withInboundClusterStatName(String inboundClusterStatName){
            this.inboundClusterStatName=inboundClusterStatName; return (A) this;
    }

    public Boolean hasInboundClusterStatName(){
            return this.inboundClusterStatName != null;
    }

    public A withNewInboundClusterStatName(String arg1){
            return (A)withInboundClusterStatName(new String(arg1));
    }

    public A withNewInboundClusterStatName(StringBuilder arg1){
            return (A)withInboundClusterStatName(new String(arg1));
    }

    public A withNewInboundClusterStatName(StringBuffer arg1){
            return (A)withInboundClusterStatName(new String(arg1));
    }

    public String getIngressClass(){
            return this.ingressClass;
    }

    public A withIngressClass(String ingressClass){
            this.ingressClass=ingressClass; return (A) this;
    }

    public Boolean hasIngressClass(){
            return this.ingressClass != null;
    }

    public A withNewIngressClass(String arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(StringBuilder arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(StringBuffer arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public IngressControllerMode getIngressControllerMode(){
            return this.ingressControllerMode;
    }

    public A withIngressControllerMode(IngressControllerMode ingressControllerMode){
            this.ingressControllerMode=ingressControllerMode; return (A) this;
    }

    public Boolean hasIngressControllerMode(){
            return this.ingressControllerMode != null;
    }

    public String getIngressSelector(){
            return this.ingressSelector;
    }

    public A withIngressSelector(String ingressSelector){
            this.ingressSelector=ingressSelector; return (A) this;
    }

    public Boolean hasIngressSelector(){
            return this.ingressSelector != null;
    }

    public A withNewIngressSelector(String arg1){
            return (A)withIngressSelector(new String(arg1));
    }

    public A withNewIngressSelector(StringBuilder arg1){
            return (A)withIngressSelector(new String(arg1));
    }

    public A withNewIngressSelector(StringBuffer arg1){
            return (A)withIngressSelector(new String(arg1));
    }

    public String getIngressService(){
            return this.ingressService;
    }

    public A withIngressService(String ingressService){
            this.ingressService=ingressService; return (A) this;
    }

    public Boolean hasIngressService(){
            return this.ingressService != null;
    }

    public A withNewIngressService(String arg1){
            return (A)withIngressService(new String(arg1));
    }

    public A withNewIngressService(StringBuilder arg1){
            return (A)withIngressService(new String(arg1));
    }

    public A withNewIngressService(StringBuffer arg1){
            return (A)withIngressService(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildLocalityLbSetting instead.
 * @return The buildable object.
 */
@Deprecated public LocalityLoadBalancerSetting getLocalityLbSetting(){
            return this.localityLbSetting!=null?this.localityLbSetting.build():null;
    }

    public LocalityLoadBalancerSetting buildLocalityLbSetting(){
            return this.localityLbSetting!=null?this.localityLbSetting.build():null;
    }

    public A withLocalityLbSetting(LocalityLoadBalancerSetting localityLbSetting){
            _visitables.get("localityLbSetting").remove(this.localityLbSetting);
            if (localityLbSetting!=null){ this.localityLbSetting= new LocalityLoadBalancerSettingBuilder(localityLbSetting); _visitables.get("localityLbSetting").add(this.localityLbSetting);} return (A) this;
    }

    public Boolean hasLocalityLbSetting(){
            return this.localityLbSetting != null;
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> withNewLocalityLbSetting(){
            return new LocalityLbSettingNestedImpl();
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> withNewLocalityLbSettingLike(LocalityLoadBalancerSetting item){
            return new LocalityLbSettingNestedImpl(item);
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> editLocalityLbSetting(){
            return withNewLocalityLbSettingLike(getLocalityLbSetting());
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> editOrNewLocalityLbSetting(){
            return withNewLocalityLbSettingLike(getLocalityLbSetting() != null ? getLocalityLbSetting(): new LocalityLoadBalancerSettingBuilder().build());
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> editOrNewLocalityLbSettingLike(LocalityLoadBalancerSetting item){
            return withNewLocalityLbSettingLike(getLocalityLbSetting() != null ? getLocalityLbSetting(): item);
    }

    public String getMixerAddress(){
            return this.mixerAddress;
    }

    public A withMixerAddress(String mixerAddress){
            this.mixerAddress=mixerAddress; return (A) this;
    }

    public Boolean hasMixerAddress(){
            return this.mixerAddress != null;
    }

    public A withNewMixerAddress(String arg1){
            return (A)withMixerAddress(new String(arg1));
    }

    public A withNewMixerAddress(StringBuilder arg1){
            return (A)withMixerAddress(new String(arg1));
    }

    public A withNewMixerAddress(StringBuffer arg1){
            return (A)withMixerAddress(new String(arg1));
    }

    public String getMixerCheckServer(){
            return this.mixerCheckServer;
    }

    public A withMixerCheckServer(String mixerCheckServer){
            this.mixerCheckServer=mixerCheckServer; return (A) this;
    }

    public Boolean hasMixerCheckServer(){
            return this.mixerCheckServer != null;
    }

    public A withNewMixerCheckServer(String arg1){
            return (A)withMixerCheckServer(new String(arg1));
    }

    public A withNewMixerCheckServer(StringBuilder arg1){
            return (A)withMixerCheckServer(new String(arg1));
    }

    public A withNewMixerCheckServer(StringBuffer arg1){
            return (A)withMixerCheckServer(new String(arg1));
    }

    public String getMixerReportServer(){
            return this.mixerReportServer;
    }

    public A withMixerReportServer(String mixerReportServer){
            this.mixerReportServer=mixerReportServer; return (A) this;
    }

    public Boolean hasMixerReportServer(){
            return this.mixerReportServer != null;
    }

    public A withNewMixerReportServer(String arg1){
            return (A)withMixerReportServer(new String(arg1));
    }

    public A withNewMixerReportServer(StringBuilder arg1){
            return (A)withMixerReportServer(new String(arg1));
    }

    public A withNewMixerReportServer(StringBuffer arg1){
            return (A)withMixerReportServer(new String(arg1));
    }

    public String getOutboundClusterStatName(){
            return this.outboundClusterStatName;
    }

    public A withOutboundClusterStatName(String outboundClusterStatName){
            this.outboundClusterStatName=outboundClusterStatName; return (A) this;
    }

    public Boolean hasOutboundClusterStatName(){
            return this.outboundClusterStatName != null;
    }

    public A withNewOutboundClusterStatName(String arg1){
            return (A)withOutboundClusterStatName(new String(arg1));
    }

    public A withNewOutboundClusterStatName(StringBuilder arg1){
            return (A)withOutboundClusterStatName(new String(arg1));
    }

    public A withNewOutboundClusterStatName(StringBuffer arg1){
            return (A)withOutboundClusterStatName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildOutboundTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public OutboundTrafficPolicy getOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public OutboundTrafficPolicy buildOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public A withOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy){
            _visitables.get("outboundTrafficPolicy").remove(this.outboundTrafficPolicy);
            if (outboundTrafficPolicy!=null){ this.outboundTrafficPolicy= new OutboundTrafficPolicyBuilder(outboundTrafficPolicy); _visitables.get("outboundTrafficPolicy").add(this.outboundTrafficPolicy);} return (A) this;
    }

    public Boolean hasOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy != null;
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy(){
            return new OutboundTrafficPolicyNestedImpl();
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item){
            return new OutboundTrafficPolicyNestedImpl(item);
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy());
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): new OutboundTrafficPolicyBuilder().build());
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): item);
    }

    public Boolean isPolicyCheckFailOpen(){
            return this.policyCheckFailOpen;
    }

    public A withPolicyCheckFailOpen(Boolean policyCheckFailOpen){
            this.policyCheckFailOpen=policyCheckFailOpen; return (A) this;
    }

    public Boolean hasPolicyCheckFailOpen(){
            return this.policyCheckFailOpen != null;
    }

    public A withNewPolicyCheckFailOpen(String arg1){
            return (A)withPolicyCheckFailOpen(new Boolean(arg1));
    }

    public A withNewPolicyCheckFailOpen(boolean arg1){
            return (A)withPolicyCheckFailOpen(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildProtocolDetectionTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getProtocolDetectionTimeout(){
            return this.protocolDetectionTimeout!=null?this.protocolDetectionTimeout.build():null;
    }

    public Duration buildProtocolDetectionTimeout(){
            return this.protocolDetectionTimeout!=null?this.protocolDetectionTimeout.build():null;
    }

    public A withProtocolDetectionTimeout(Duration protocolDetectionTimeout){
            _visitables.get("protocolDetectionTimeout").remove(this.protocolDetectionTimeout);
            if (protocolDetectionTimeout!=null){ this.protocolDetectionTimeout= new DurationBuilder(protocolDetectionTimeout); _visitables.get("protocolDetectionTimeout").add(this.protocolDetectionTimeout);} return (A) this;
    }

    public Boolean hasProtocolDetectionTimeout(){
            return this.protocolDetectionTimeout != null;
    }

    public A withNewProtocolDetectionTimeout(Integer nanos,Long seconds){
            return (A)withProtocolDetectionTimeout(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> withNewProtocolDetectionTimeout(){
            return new ProtocolDetectionTimeoutNestedImpl();
    }

    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> withNewProtocolDetectionTimeoutLike(Duration item){
            return new ProtocolDetectionTimeoutNestedImpl(item);
    }

    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> editProtocolDetectionTimeout(){
            return withNewProtocolDetectionTimeoutLike(getProtocolDetectionTimeout());
    }

    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> editOrNewProtocolDetectionTimeout(){
            return withNewProtocolDetectionTimeoutLike(getProtocolDetectionTimeout() != null ? getProtocolDetectionTimeout(): new DurationBuilder().build());
    }

    public MeshConfigFluent.ProtocolDetectionTimeoutNested<A> editOrNewProtocolDetectionTimeoutLike(Duration item){
            return withNewProtocolDetectionTimeoutLike(getProtocolDetectionTimeout() != null ? getProtocolDetectionTimeout(): item);
    }

    public Integer getProxyHttpPort(){
            return this.proxyHttpPort;
    }

    public A withProxyHttpPort(Integer proxyHttpPort){
            this.proxyHttpPort=proxyHttpPort; return (A) this;
    }

    public Boolean hasProxyHttpPort(){
            return this.proxyHttpPort != null;
    }

    public Integer getProxyListenPort(){
            return this.proxyListenPort;
    }

    public A withProxyListenPort(Integer proxyListenPort){
            this.proxyListenPort=proxyListenPort; return (A) this;
    }

    public Boolean hasProxyListenPort(){
            return this.proxyListenPort != null;
    }

    
/**
 * This method has been deprecated, please use method buildRdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getRdsRefreshDelay(){
            return this.rdsRefreshDelay!=null?this.rdsRefreshDelay.build():null;
    }

    public Duration buildRdsRefreshDelay(){
            return this.rdsRefreshDelay!=null?this.rdsRefreshDelay.build():null;
    }

    public A withRdsRefreshDelay(Duration rdsRefreshDelay){
            _visitables.get("rdsRefreshDelay").remove(this.rdsRefreshDelay);
            if (rdsRefreshDelay!=null){ this.rdsRefreshDelay= new DurationBuilder(rdsRefreshDelay); _visitables.get("rdsRefreshDelay").add(this.rdsRefreshDelay);} return (A) this;
    }

    public Boolean hasRdsRefreshDelay(){
            return this.rdsRefreshDelay != null;
    }

    public A withNewRdsRefreshDelay(Integer nanos,Long seconds){
            return (A)withRdsRefreshDelay(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelay(){
            return new RdsRefreshDelayNestedImpl();
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelayLike(Duration item){
            return new RdsRefreshDelayNestedImpl(item);
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editRdsRefreshDelay(){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay());
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelay(){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay() != null ? getRdsRefreshDelay(): new DurationBuilder().build());
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelayLike(Duration item){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay() != null ? getRdsRefreshDelay(): item);
    }

    public Integer getReportBatchMaxEntries(){
            return this.reportBatchMaxEntries;
    }

    public A withReportBatchMaxEntries(Integer reportBatchMaxEntries){
            this.reportBatchMaxEntries=reportBatchMaxEntries; return (A) this;
    }

    public Boolean hasReportBatchMaxEntries(){
            return this.reportBatchMaxEntries != null;
    }

    
/**
 * This method has been deprecated, please use method buildReportBatchMaxTime instead.
 * @return The buildable object.
 */
@Deprecated public Duration getReportBatchMaxTime(){
            return this.reportBatchMaxTime!=null?this.reportBatchMaxTime.build():null;
    }

    public Duration buildReportBatchMaxTime(){
            return this.reportBatchMaxTime!=null?this.reportBatchMaxTime.build():null;
    }

    public A withReportBatchMaxTime(Duration reportBatchMaxTime){
            _visitables.get("reportBatchMaxTime").remove(this.reportBatchMaxTime);
            if (reportBatchMaxTime!=null){ this.reportBatchMaxTime= new DurationBuilder(reportBatchMaxTime); _visitables.get("reportBatchMaxTime").add(this.reportBatchMaxTime);} return (A) this;
    }

    public Boolean hasReportBatchMaxTime(){
            return this.reportBatchMaxTime != null;
    }

    public A withNewReportBatchMaxTime(Integer nanos,Long seconds){
            return (A)withReportBatchMaxTime(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.ReportBatchMaxTimeNested<A> withNewReportBatchMaxTime(){
            return new ReportBatchMaxTimeNestedImpl();
    }

    public MeshConfigFluent.ReportBatchMaxTimeNested<A> withNewReportBatchMaxTimeLike(Duration item){
            return new ReportBatchMaxTimeNestedImpl(item);
    }

    public MeshConfigFluent.ReportBatchMaxTimeNested<A> editReportBatchMaxTime(){
            return withNewReportBatchMaxTimeLike(getReportBatchMaxTime());
    }

    public MeshConfigFluent.ReportBatchMaxTimeNested<A> editOrNewReportBatchMaxTime(){
            return withNewReportBatchMaxTimeLike(getReportBatchMaxTime() != null ? getReportBatchMaxTime(): new DurationBuilder().build());
    }

    public MeshConfigFluent.ReportBatchMaxTimeNested<A> editOrNewReportBatchMaxTimeLike(Duration item){
            return withNewReportBatchMaxTimeLike(getReportBatchMaxTime() != null ? getReportBatchMaxTime(): item);
    }

    public String getRootNamespace(){
            return this.rootNamespace;
    }

    public A withRootNamespace(String rootNamespace){
            this.rootNamespace=rootNamespace; return (A) this;
    }

    public Boolean hasRootNamespace(){
            return this.rootNamespace != null;
    }

    public A withNewRootNamespace(String arg1){
            return (A)withRootNamespace(new String(arg1));
    }

    public A withNewRootNamespace(StringBuilder arg1){
            return (A)withRootNamespace(new String(arg1));
    }

    public A withNewRootNamespace(StringBuffer arg1){
            return (A)withRootNamespace(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getSdsRefreshDelay(){
            return this.sdsRefreshDelay!=null?this.sdsRefreshDelay.build():null;
    }

    public Duration buildSdsRefreshDelay(){
            return this.sdsRefreshDelay!=null?this.sdsRefreshDelay.build():null;
    }

    public A withSdsRefreshDelay(Duration sdsRefreshDelay){
            _visitables.get("sdsRefreshDelay").remove(this.sdsRefreshDelay);
            if (sdsRefreshDelay!=null){ this.sdsRefreshDelay= new DurationBuilder(sdsRefreshDelay); _visitables.get("sdsRefreshDelay").add(this.sdsRefreshDelay);} return (A) this;
    }

    public Boolean hasSdsRefreshDelay(){
            return this.sdsRefreshDelay != null;
    }

    public A withNewSdsRefreshDelay(Integer nanos,Long seconds){
            return (A)withSdsRefreshDelay(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelay(){
            return new SdsRefreshDelayNestedImpl();
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelayLike(Duration item){
            return new SdsRefreshDelayNestedImpl(item);
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editSdsRefreshDelay(){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay());
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelay(){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay() != null ? getSdsRefreshDelay(): new DurationBuilder().build());
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelayLike(Duration item){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay() != null ? getSdsRefreshDelay(): item);
    }

    public String getSdsUdsPath(){
            return this.sdsUdsPath;
    }

    public A withSdsUdsPath(String sdsUdsPath){
            this.sdsUdsPath=sdsUdsPath; return (A) this;
    }

    public Boolean hasSdsUdsPath(){
            return this.sdsUdsPath != null;
    }

    public A withNewSdsUdsPath(String arg1){
            return (A)withSdsUdsPath(new String(arg1));
    }

    public A withNewSdsUdsPath(StringBuilder arg1){
            return (A)withSdsUdsPath(new String(arg1));
    }

    public A withNewSdsUdsPath(StringBuffer arg1){
            return (A)withSdsUdsPath(new String(arg1));
    }

    public Boolean isSdsUseK8sSaJwt(){
            return this.sdsUseK8sSaJwt;
    }

    public A withSdsUseK8sSaJwt(Boolean sdsUseK8sSaJwt){
            this.sdsUseK8sSaJwt=sdsUseK8sSaJwt; return (A) this;
    }

    public Boolean hasSdsUseK8sSaJwt(){
            return this.sdsUseK8sSaJwt != null;
    }

    public A withNewSdsUseK8sSaJwt(String arg1){
            return (A)withSdsUseK8sSaJwt(new Boolean(arg1));
    }

    public A withNewSdsUseK8sSaJwt(boolean arg1){
            return (A)withSdsUseK8sSaJwt(new Boolean(arg1));
    }

    public A addToServiceSettings(int index,ServiceSettings item){
            if (this.serviceSettings == null) {this.serviceSettings = new ArrayList<ServiceSettingsBuilder>();}
            ServiceSettingsBuilder builder = new ServiceSettingsBuilder(item);_visitables.get("serviceSettings").add(index >= 0 ? index : _visitables.get("serviceSettings").size(), builder);this.serviceSettings.add(index >= 0 ? index : serviceSettings.size(), builder); return (A)this;
    }

    public A setToServiceSettings(int index,ServiceSettings item){
            if (this.serviceSettings == null) {this.serviceSettings = new ArrayList<ServiceSettingsBuilder>();}
            ServiceSettingsBuilder builder = new ServiceSettingsBuilder(item);
            if (index < 0 || index >= _visitables.get("serviceSettings").size()) { _visitables.get("serviceSettings").add(builder); } else { _visitables.get("serviceSettings").set(index, builder);}
            if (index < 0 || index >= serviceSettings.size()) { serviceSettings.add(builder); } else { serviceSettings.set(index, builder);}
             return (A)this;
    }

    public A addToServiceSettings(ServiceSettings... items){
            if (this.serviceSettings == null) {this.serviceSettings = new ArrayList<ServiceSettingsBuilder>();}
            for (ServiceSettings item : items) {ServiceSettingsBuilder builder = new ServiceSettingsBuilder(item);_visitables.get("serviceSettings").add(builder);this.serviceSettings.add(builder);} return (A)this;
    }

    public A addAllToServiceSettings(Collection<ServiceSettings> items){
            if (this.serviceSettings == null) {this.serviceSettings = new ArrayList<ServiceSettingsBuilder>();}
            for (ServiceSettings item : items) {ServiceSettingsBuilder builder = new ServiceSettingsBuilder(item);_visitables.get("serviceSettings").add(builder);this.serviceSettings.add(builder);} return (A)this;
    }

    public A removeFromServiceSettings(ServiceSettings... items){
            for (ServiceSettings item : items) {ServiceSettingsBuilder builder = new ServiceSettingsBuilder(item);_visitables.get("serviceSettings").remove(builder);if (this.serviceSettings != null) {this.serviceSettings.remove(builder);}} return (A)this;
    }

    public A removeAllFromServiceSettings(Collection<ServiceSettings> items){
            for (ServiceSettings item : items) {ServiceSettingsBuilder builder = new ServiceSettingsBuilder(item);_visitables.get("serviceSettings").remove(builder);if (this.serviceSettings != null) {this.serviceSettings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromServiceSettings(io.fabric8.kubernetes.api.builder.Predicate<ServiceSettingsBuilder> predicate){
            if (serviceSettings == null) return (A) this;
            final Iterator<ServiceSettingsBuilder> each = serviceSettings.iterator();
            final List visitables = _visitables.get("serviceSettings");
            while (each.hasNext()) {
              ServiceSettingsBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildServiceSettings instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceSettings> getServiceSettings(){
            return build(serviceSettings);
    }

    public List<ServiceSettings> buildServiceSettings(){
            return build(serviceSettings);
    }

    public ServiceSettings buildServiceSetting(int index){
            return this.serviceSettings.get(index).build();
    }

    public ServiceSettings buildFirstServiceSetting(){
            return this.serviceSettings.get(0).build();
    }

    public ServiceSettings buildLastServiceSetting(){
            return this.serviceSettings.get(serviceSettings.size() - 1).build();
    }

    public ServiceSettings buildMatchingServiceSetting(io.fabric8.kubernetes.api.builder.Predicate<ServiceSettingsBuilder> predicate){
            for (ServiceSettingsBuilder item: serviceSettings) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingServiceSetting(io.fabric8.kubernetes.api.builder.Predicate<ServiceSettingsBuilder> predicate){
            for (ServiceSettingsBuilder item: serviceSettings) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withServiceSettings(List<ServiceSettings> serviceSettings){
            if (this.serviceSettings != null) { _visitables.get("serviceSettings").removeAll(this.serviceSettings);}
            if (serviceSettings != null) {this.serviceSettings = new ArrayList<ServiceSettingsBuilder>(); for (ServiceSettings item : serviceSettings){this.addToServiceSettings(item);}} else { this.serviceSettings = null;} return (A) this;
    }

    public A withServiceSettings(ServiceSettings... serviceSettings){
            if (this.serviceSettings != null) {this.serviceSettings.clear();}
            if (serviceSettings != null) {for (ServiceSettings item :serviceSettings){ this.addToServiceSettings(item);}} return (A) this;
    }

    public Boolean hasServiceSettings(){
            return serviceSettings != null && !serviceSettings.isEmpty();
    }

    public MeshConfigFluent.ServiceSettingsNested<A> addNewServiceSetting(){
            return new ServiceSettingsNestedImpl();
    }

    public MeshConfigFluent.ServiceSettingsNested<A> addNewServiceSettingLike(ServiceSettings item){
            return new ServiceSettingsNestedImpl(-1, item);
    }

    public MeshConfigFluent.ServiceSettingsNested<A> setNewServiceSettingLike(int index,ServiceSettings item){
            return new ServiceSettingsNestedImpl(index, item);
    }

    public MeshConfigFluent.ServiceSettingsNested<A> editServiceSetting(int index){
            if (serviceSettings.size() <= index) throw new RuntimeException("Can't edit serviceSettings. Index exceeds size.");
            return setNewServiceSettingLike(index, buildServiceSetting(index));
    }

    public MeshConfigFluent.ServiceSettingsNested<A> editFirstServiceSetting(){
            if (serviceSettings.size() == 0) throw new RuntimeException("Can't edit first serviceSettings. The list is empty.");
            return setNewServiceSettingLike(0, buildServiceSetting(0));
    }

    public MeshConfigFluent.ServiceSettingsNested<A> editLastServiceSetting(){
            int index = serviceSettings.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last serviceSettings. The list is empty.");
            return setNewServiceSettingLike(index, buildServiceSetting(index));
    }

    public MeshConfigFluent.ServiceSettingsNested<A> editMatchingServiceSetting(io.fabric8.kubernetes.api.builder.Predicate<ServiceSettingsBuilder> predicate){
            int index = -1;
            for (int i=0;i<serviceSettings.size();i++) { 
            if (predicate.apply(serviceSettings.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching serviceSettings. No match found.");
            return setNewServiceSettingLike(index, buildServiceSetting(index));
    }

    public Boolean isSidecarToTelemetrySessionAffinity(){
            return this.sidecarToTelemetrySessionAffinity;
    }

    public A withSidecarToTelemetrySessionAffinity(Boolean sidecarToTelemetrySessionAffinity){
            this.sidecarToTelemetrySessionAffinity=sidecarToTelemetrySessionAffinity; return (A) this;
    }

    public Boolean hasSidecarToTelemetrySessionAffinity(){
            return this.sidecarToTelemetrySessionAffinity != null;
    }

    public A withNewSidecarToTelemetrySessionAffinity(String arg1){
            return (A)withSidecarToTelemetrySessionAffinity(new Boolean(arg1));
    }

    public A withNewSidecarToTelemetrySessionAffinity(boolean arg1){
            return (A)withSidecarToTelemetrySessionAffinity(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTcpKeepalive instead.
 * @return The buildable object.
 */
@Deprecated public TcpKeepalive getTcpKeepalive(){
            return this.tcpKeepalive!=null?this.tcpKeepalive.build():null;
    }

    public TcpKeepalive buildTcpKeepalive(){
            return this.tcpKeepalive!=null?this.tcpKeepalive.build():null;
    }

    public A withTcpKeepalive(TcpKeepalive tcpKeepalive){
            _visitables.get("tcpKeepalive").remove(this.tcpKeepalive);
            if (tcpKeepalive!=null){ this.tcpKeepalive= new TcpKeepaliveBuilder(tcpKeepalive); _visitables.get("tcpKeepalive").add(this.tcpKeepalive);} return (A) this;
    }

    public Boolean hasTcpKeepalive(){
            return this.tcpKeepalive != null;
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> withNewTcpKeepalive(){
            return new TcpKeepaliveNestedImpl();
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> withNewTcpKeepaliveLike(TcpKeepalive item){
            return new TcpKeepaliveNestedImpl(item);
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> editTcpKeepalive(){
            return withNewTcpKeepaliveLike(getTcpKeepalive());
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> editOrNewTcpKeepalive(){
            return withNewTcpKeepaliveLike(getTcpKeepalive() != null ? getTcpKeepalive(): new TcpKeepaliveBuilder().build());
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> editOrNewTcpKeepaliveLike(TcpKeepalive item){
            return withNewTcpKeepaliveLike(getTcpKeepalive() != null ? getTcpKeepalive(): item);
    }

    
/**
 * This method has been deprecated, please use method buildThriftConfig instead.
 * @return The buildable object.
 */
@Deprecated public ThriftConfig getThriftConfig(){
            return this.thriftConfig!=null?this.thriftConfig.build():null;
    }

    public ThriftConfig buildThriftConfig(){
            return this.thriftConfig!=null?this.thriftConfig.build():null;
    }

    public A withThriftConfig(ThriftConfig thriftConfig){
            _visitables.get("thriftConfig").remove(this.thriftConfig);
            if (thriftConfig!=null){ this.thriftConfig= new ThriftConfigBuilder(thriftConfig); _visitables.get("thriftConfig").add(this.thriftConfig);} return (A) this;
    }

    public Boolean hasThriftConfig(){
            return this.thriftConfig != null;
    }

    public MeshConfigFluent.ThriftConfigNested<A> withNewThriftConfig(){
            return new ThriftConfigNestedImpl();
    }

    public MeshConfigFluent.ThriftConfigNested<A> withNewThriftConfigLike(ThriftConfig item){
            return new ThriftConfigNestedImpl(item);
    }

    public MeshConfigFluent.ThriftConfigNested<A> editThriftConfig(){
            return withNewThriftConfigLike(getThriftConfig());
    }

    public MeshConfigFluent.ThriftConfigNested<A> editOrNewThriftConfig(){
            return withNewThriftConfigLike(getThriftConfig() != null ? getThriftConfig(): new ThriftConfigBuilder().build());
    }

    public MeshConfigFluent.ThriftConfigNested<A> editOrNewThriftConfigLike(ThriftConfig item){
            return withNewThriftConfigLike(getThriftConfig() != null ? getThriftConfig(): item);
    }

    public String getTrustDomain(){
            return this.trustDomain;
    }

    public A withTrustDomain(String trustDomain){
            this.trustDomain=trustDomain; return (A) this;
    }

    public Boolean hasTrustDomain(){
            return this.trustDomain != null;
    }

    public A withNewTrustDomain(String arg1){
            return (A)withTrustDomain(new String(arg1));
    }

    public A withNewTrustDomain(StringBuilder arg1){
            return (A)withTrustDomain(new String(arg1));
    }

    public A withNewTrustDomain(StringBuffer arg1){
            return (A)withTrustDomain(new String(arg1));
    }

    public A addToTrustDomainAliases(int index,String item){
            if (this.trustDomainAliases == null) {this.trustDomainAliases = new ArrayList<String>();}
            this.trustDomainAliases.add(index, item);
            return (A)this;
    }

    public A setToTrustDomainAliases(int index,String item){
            if (this.trustDomainAliases == null) {this.trustDomainAliases = new ArrayList<String>();}
            this.trustDomainAliases.set(index, item); return (A)this;
    }

    public A addToTrustDomainAliases(String... items){
            if (this.trustDomainAliases == null) {this.trustDomainAliases = new ArrayList<String>();}
            for (String item : items) {this.trustDomainAliases.add(item);} return (A)this;
    }

    public A addAllToTrustDomainAliases(Collection<String> items){
            if (this.trustDomainAliases == null) {this.trustDomainAliases = new ArrayList<String>();}
            for (String item : items) {this.trustDomainAliases.add(item);} return (A)this;
    }

    public A removeFromTrustDomainAliases(String... items){
            for (String item : items) {if (this.trustDomainAliases!= null){ this.trustDomainAliases.remove(item);}} return (A)this;
    }

    public A removeAllFromTrustDomainAliases(Collection<String> items){
            for (String item : items) {if (this.trustDomainAliases!= null){ this.trustDomainAliases.remove(item);}} return (A)this;
    }

    public List<String> getTrustDomainAliases(){
            return this.trustDomainAliases;
    }

    public String getTrustDomainAlias(int index){
            return this.trustDomainAliases.get(index);
    }

    public String getFirstTrustDomainAlias(){
            return this.trustDomainAliases.get(0);
    }

    public String getLastTrustDomainAlias(){
            return this.trustDomainAliases.get(trustDomainAliases.size() - 1);
    }

    public String getMatchingTrustDomainAlias(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: trustDomainAliases) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTrustDomainAlias(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: trustDomainAliases) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTrustDomainAliases(List<String> trustDomainAliases){
            if (this.trustDomainAliases != null) { _visitables.get("trustDomainAliases").removeAll(this.trustDomainAliases);}
            if (trustDomainAliases != null) {this.trustDomainAliases = new ArrayList<String>(); for (String item : trustDomainAliases){this.addToTrustDomainAliases(item);}} else { this.trustDomainAliases = null;} return (A) this;
    }

    public A withTrustDomainAliases(String... trustDomainAliases){
            if (this.trustDomainAliases != null) {this.trustDomainAliases.clear();}
            if (trustDomainAliases != null) {for (String item :trustDomainAliases){ this.addToTrustDomainAliases(item);}} return (A) this;
    }

    public Boolean hasTrustDomainAliases(){
            return trustDomainAliases != null && !trustDomainAliases.isEmpty();
    }

    public A addNewTrustDomainAlias(String arg1){
            return (A)addToTrustDomainAliases(new String(arg1));
    }

    public A addNewTrustDomainAlias(StringBuilder arg1){
            return (A)addToTrustDomainAliases(new String(arg1));
    }

    public A addNewTrustDomainAlias(StringBuffer arg1){
            return (A)addToTrustDomainAliases(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            MeshConfigFluentImpl that = (MeshConfigFluentImpl) o;
            if (accessLogEncoding != null ? !accessLogEncoding.equals(that.accessLogEncoding) :that.accessLogEncoding != null) return false;
            if (accessLogFile != null ? !accessLogFile.equals(that.accessLogFile) :that.accessLogFile != null) return false;
            if (accessLogFormat != null ? !accessLogFormat.equals(that.accessLogFormat) :that.accessLogFormat != null) return false;
            if (authPolicy != null ? !authPolicy.equals(that.authPolicy) :that.authPolicy != null) return false;
            if (certificates != null ? !certificates.equals(that.certificates) :that.certificates != null) return false;
            if (configSources != null ? !configSources.equals(that.configSources) :that.configSources != null) return false;
            if (connectTimeout != null ? !connectTimeout.equals(that.connectTimeout) :that.connectTimeout != null) return false;
            if (defaultConfig != null ? !defaultConfig.equals(that.defaultConfig) :that.defaultConfig != null) return false;
            if (defaultDestinationRuleExportTo != null ? !defaultDestinationRuleExportTo.equals(that.defaultDestinationRuleExportTo) :that.defaultDestinationRuleExportTo != null) return false;
            if (defaultServiceExportTo != null ? !defaultServiceExportTo.equals(that.defaultServiceExportTo) :that.defaultServiceExportTo != null) return false;
            if (defaultVirtualServiceExportTo != null ? !defaultVirtualServiceExportTo.equals(that.defaultVirtualServiceExportTo) :that.defaultVirtualServiceExportTo != null) return false;
            if (disableMixerHttpReports != null ? !disableMixerHttpReports.equals(that.disableMixerHttpReports) :that.disableMixerHttpReports != null) return false;
            if (disablePolicyChecks != null ? !disablePolicyChecks.equals(that.disablePolicyChecks) :that.disablePolicyChecks != null) return false;
            if (disableReportBatch != null ? !disableReportBatch.equals(that.disableReportBatch) :that.disableReportBatch != null) return false;
            if (dnsRefreshRate != null ? !dnsRefreshRate.equals(that.dnsRefreshRate) :that.dnsRefreshRate != null) return false;
            if (enableAutoMtls != null ? !enableAutoMtls.equals(that.enableAutoMtls) :that.enableAutoMtls != null) return false;
            if (enableClientSidePolicyCheck != null ? !enableClientSidePolicyCheck.equals(that.enableClientSidePolicyCheck) :that.enableClientSidePolicyCheck != null) return false;
            if (enableEnvoyAccessLogService != null ? !enableEnvoyAccessLogService.equals(that.enableEnvoyAccessLogService) :that.enableEnvoyAccessLogService != null) return false;
            if (enablePrometheusMerge != null ? !enablePrometheusMerge.equals(that.enablePrometheusMerge) :that.enablePrometheusMerge != null) return false;
            if (enableSdsTokenMount != null ? !enableSdsTokenMount.equals(that.enableSdsTokenMount) :that.enableSdsTokenMount != null) return false;
            if (enableTracing != null ? !enableTracing.equals(that.enableTracing) :that.enableTracing != null) return false;
            if (h2UpgradePolicy != null ? !h2UpgradePolicy.equals(that.h2UpgradePolicy) :that.h2UpgradePolicy != null) return false;
            if (inboundClusterStatName != null ? !inboundClusterStatName.equals(that.inboundClusterStatName) :that.inboundClusterStatName != null) return false;
            if (ingressClass != null ? !ingressClass.equals(that.ingressClass) :that.ingressClass != null) return false;
            if (ingressControllerMode != null ? !ingressControllerMode.equals(that.ingressControllerMode) :that.ingressControllerMode != null) return false;
            if (ingressSelector != null ? !ingressSelector.equals(that.ingressSelector) :that.ingressSelector != null) return false;
            if (ingressService != null ? !ingressService.equals(that.ingressService) :that.ingressService != null) return false;
            if (localityLbSetting != null ? !localityLbSetting.equals(that.localityLbSetting) :that.localityLbSetting != null) return false;
            if (mixerAddress != null ? !mixerAddress.equals(that.mixerAddress) :that.mixerAddress != null) return false;
            if (mixerCheckServer != null ? !mixerCheckServer.equals(that.mixerCheckServer) :that.mixerCheckServer != null) return false;
            if (mixerReportServer != null ? !mixerReportServer.equals(that.mixerReportServer) :that.mixerReportServer != null) return false;
            if (outboundClusterStatName != null ? !outboundClusterStatName.equals(that.outboundClusterStatName) :that.outboundClusterStatName != null) return false;
            if (outboundTrafficPolicy != null ? !outboundTrafficPolicy.equals(that.outboundTrafficPolicy) :that.outboundTrafficPolicy != null) return false;
            if (policyCheckFailOpen != null ? !policyCheckFailOpen.equals(that.policyCheckFailOpen) :that.policyCheckFailOpen != null) return false;
            if (protocolDetectionTimeout != null ? !protocolDetectionTimeout.equals(that.protocolDetectionTimeout) :that.protocolDetectionTimeout != null) return false;
            if (proxyHttpPort != null ? !proxyHttpPort.equals(that.proxyHttpPort) :that.proxyHttpPort != null) return false;
            if (proxyListenPort != null ? !proxyListenPort.equals(that.proxyListenPort) :that.proxyListenPort != null) return false;
            if (rdsRefreshDelay != null ? !rdsRefreshDelay.equals(that.rdsRefreshDelay) :that.rdsRefreshDelay != null) return false;
            if (reportBatchMaxEntries != null ? !reportBatchMaxEntries.equals(that.reportBatchMaxEntries) :that.reportBatchMaxEntries != null) return false;
            if (reportBatchMaxTime != null ? !reportBatchMaxTime.equals(that.reportBatchMaxTime) :that.reportBatchMaxTime != null) return false;
            if (rootNamespace != null ? !rootNamespace.equals(that.rootNamespace) :that.rootNamespace != null) return false;
            if (sdsRefreshDelay != null ? !sdsRefreshDelay.equals(that.sdsRefreshDelay) :that.sdsRefreshDelay != null) return false;
            if (sdsUdsPath != null ? !sdsUdsPath.equals(that.sdsUdsPath) :that.sdsUdsPath != null) return false;
            if (sdsUseK8sSaJwt != null ? !sdsUseK8sSaJwt.equals(that.sdsUseK8sSaJwt) :that.sdsUseK8sSaJwt != null) return false;
            if (serviceSettings != null ? !serviceSettings.equals(that.serviceSettings) :that.serviceSettings != null) return false;
            if (sidecarToTelemetrySessionAffinity != null ? !sidecarToTelemetrySessionAffinity.equals(that.sidecarToTelemetrySessionAffinity) :that.sidecarToTelemetrySessionAffinity != null) return false;
            if (tcpKeepalive != null ? !tcpKeepalive.equals(that.tcpKeepalive) :that.tcpKeepalive != null) return false;
            if (thriftConfig != null ? !thriftConfig.equals(that.thriftConfig) :that.thriftConfig != null) return false;
            if (trustDomain != null ? !trustDomain.equals(that.trustDomain) :that.trustDomain != null) return false;
            if (trustDomainAliases != null ? !trustDomainAliases.equals(that.trustDomainAliases) :that.trustDomainAliases != null) return false;
            return true;
    }


    public class CertificatesNestedImpl<N> extends CertificateFluentImpl<MeshConfigFluent.CertificatesNested<N>> implements MeshConfigFluent.CertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CertificateBuilder builder;
        private final int index;
    
            CertificatesNestedImpl(int index,Certificate item){
                    this.index = index;
                    this.builder = new CertificateBuilder(this, item);
            }
            CertificatesNestedImpl(){
                    this.index = -1;
                    this.builder = new CertificateBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.setToCertificates(index,builder.build());
    }
    public N endCertificate(){
            return and();
    }

}
    public class ConfigSourcesNestedImpl<N> extends ConfigSourceFluentImpl<MeshConfigFluent.ConfigSourcesNested<N>> implements MeshConfigFluent.ConfigSourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigSourceBuilder builder;
        private final int index;
    
            ConfigSourcesNestedImpl(int index,ConfigSource item){
                    this.index = index;
                    this.builder = new ConfigSourceBuilder(this, item);
            }
            ConfigSourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new ConfigSourceBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.setToConfigSources(index,builder.build());
    }
    public N endConfigSource(){
            return and();
    }

}
    public class ConnectTimeoutNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.ConnectTimeoutNested<N>> implements MeshConfigFluent.ConnectTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ConnectTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ConnectTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withConnectTimeout(builder.build());
    }
    public N endConnectTimeout(){
            return and();
    }

}
    public class DefaultConfigNestedImpl<N> extends ProxyConfigFluentImpl<MeshConfigFluent.DefaultConfigNested<N>> implements MeshConfigFluent.DefaultConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProxyConfigBuilder builder;
    
            DefaultConfigNestedImpl(ProxyConfig item){
                    this.builder = new ProxyConfigBuilder(this, item);
            }
            DefaultConfigNestedImpl(){
                    this.builder = new ProxyConfigBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withDefaultConfig(builder.build());
    }
    public N endDefaultConfig(){
            return and();
    }

}
    public class DnsRefreshRateNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.DnsRefreshRateNested<N>> implements MeshConfigFluent.DnsRefreshRateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            DnsRefreshRateNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            DnsRefreshRateNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withDnsRefreshRate(builder.build());
    }
    public N endDnsRefreshRate(){
            return and();
    }

}
    public class LocalityLbSettingNestedImpl<N> extends LocalityLoadBalancerSettingFluentImpl<MeshConfigFluent.LocalityLbSettingNested<N>> implements MeshConfigFluent.LocalityLbSettingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalityLoadBalancerSettingBuilder builder;
    
            LocalityLbSettingNestedImpl(LocalityLoadBalancerSetting item){
                    this.builder = new LocalityLoadBalancerSettingBuilder(this, item);
            }
            LocalityLbSettingNestedImpl(){
                    this.builder = new LocalityLoadBalancerSettingBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withLocalityLbSetting(builder.build());
    }
    public N endLocalityLbSetting(){
            return and();
    }

}
    public class OutboundTrafficPolicyNestedImpl<N> extends OutboundTrafficPolicyFluentImpl<MeshConfigFluent.OutboundTrafficPolicyNested<N>> implements MeshConfigFluent.OutboundTrafficPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OutboundTrafficPolicyBuilder builder;
    
            OutboundTrafficPolicyNestedImpl(OutboundTrafficPolicy item){
                    this.builder = new OutboundTrafficPolicyBuilder(this, item);
            }
            OutboundTrafficPolicyNestedImpl(){
                    this.builder = new OutboundTrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withOutboundTrafficPolicy(builder.build());
    }
    public N endOutboundTrafficPolicy(){
            return and();
    }

}
    public class ProtocolDetectionTimeoutNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.ProtocolDetectionTimeoutNested<N>> implements MeshConfigFluent.ProtocolDetectionTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ProtocolDetectionTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ProtocolDetectionTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withProtocolDetectionTimeout(builder.build());
    }
    public N endProtocolDetectionTimeout(){
            return and();
    }

}
    public class RdsRefreshDelayNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.RdsRefreshDelayNested<N>> implements MeshConfigFluent.RdsRefreshDelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            RdsRefreshDelayNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            RdsRefreshDelayNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withRdsRefreshDelay(builder.build());
    }
    public N endRdsRefreshDelay(){
            return and();
    }

}
    public class ReportBatchMaxTimeNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.ReportBatchMaxTimeNested<N>> implements MeshConfigFluent.ReportBatchMaxTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ReportBatchMaxTimeNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ReportBatchMaxTimeNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withReportBatchMaxTime(builder.build());
    }
    public N endReportBatchMaxTime(){
            return and();
    }

}
    public class SdsRefreshDelayNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.SdsRefreshDelayNested<N>> implements MeshConfigFluent.SdsRefreshDelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            SdsRefreshDelayNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            SdsRefreshDelayNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withSdsRefreshDelay(builder.build());
    }
    public N endSdsRefreshDelay(){
            return and();
    }

}
    public class ServiceSettingsNestedImpl<N> extends ServiceSettingsFluentImpl<MeshConfigFluent.ServiceSettingsNested<N>> implements MeshConfigFluent.ServiceSettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceSettingsBuilder builder;
        private final int index;
    
            ServiceSettingsNestedImpl(int index,ServiceSettings item){
                    this.index = index;
                    this.builder = new ServiceSettingsBuilder(this, item);
            }
            ServiceSettingsNestedImpl(){
                    this.index = -1;
                    this.builder = new ServiceSettingsBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.setToServiceSettings(index,builder.build());
    }
    public N endServiceSetting(){
            return and();
    }

}
    public class TcpKeepaliveNestedImpl<N> extends TcpKeepaliveFluentImpl<MeshConfigFluent.TcpKeepaliveNested<N>> implements MeshConfigFluent.TcpKeepaliveNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TcpKeepaliveBuilder builder;
    
            TcpKeepaliveNestedImpl(TcpKeepalive item){
                    this.builder = new TcpKeepaliveBuilder(this, item);
            }
            TcpKeepaliveNestedImpl(){
                    this.builder = new TcpKeepaliveBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withTcpKeepalive(builder.build());
    }
    public N endTcpKeepalive(){
            return and();
    }

}
    public class ThriftConfigNestedImpl<N> extends ThriftConfigFluentImpl<MeshConfigFluent.ThriftConfigNested<N>> implements MeshConfigFluent.ThriftConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ThriftConfigBuilder builder;
    
            ThriftConfigNestedImpl(ThriftConfig item){
                    this.builder = new ThriftConfigBuilder(this, item);
            }
            ThriftConfigNestedImpl(){
                    this.builder = new ThriftConfigBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withThriftConfig(builder.build());
    }
    public N endThriftConfig(){
            return and();
    }

}


}
