package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OutboundTrafficPolicyBuilder extends OutboundTrafficPolicyFluentImpl<OutboundTrafficPolicyBuilder> implements VisitableBuilder<OutboundTrafficPolicy,OutboundTrafficPolicyBuilder>{

    OutboundTrafficPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public OutboundTrafficPolicyBuilder(){
            this(true);
    }
    public OutboundTrafficPolicyBuilder(Boolean validationEnabled){
            this(new OutboundTrafficPolicy(), validationEnabled);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OutboundTrafficPolicy(), validationEnabled);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance){
            this(fluent, instance, true);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance){
            this(instance,true);
    }
    public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMode(instance.getMode()); 
            this.validationEnabled = validationEnabled; 
    }

    public OutboundTrafficPolicy build(){
            OutboundTrafficPolicy buildable = new OutboundTrafficPolicy(fluent.getMode());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OutboundTrafficPolicyBuilder that = (OutboundTrafficPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
