
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;
import me.snowdrop.istio.api.Int32Value;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "availabilityZone",
    "binaryPath",
    "concurrency",
    "configPath",
    "controlPlaneAuthPolicy",
    "customConfigFile",
    "discoveryAddress",
    "discoveryRefreshDelay",
    "drainDuration",
    "envoyAccessLogService",
    "envoyMetricsService",
    "envoyMetricsServiceAddress",
    "extraStatTags",
    "gatewayTopology",
    "interceptionMode",
    "meshId",
    "parentShutdownDuration",
    "proxyAdminPort",
    "proxyBootstrapTemplatePath",
    "proxyMetadata",
    "sds",
    "serviceCluster",
    "statNameLength",
    "statsdUdpAddress",
    "statusPort",
    "terminationDrainDuration",
    "tracing",
    "zipkinAddress"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ProxyConfig implements Serializable
{

    /**
     * 
     */
    @JsonProperty("availabilityZone")
    @JsonPropertyDescription("")
    private java.lang.String availabilityZone;
    /**
     * 
     */
    @JsonProperty("binaryPath")
    @JsonPropertyDescription("")
    private java.lang.String binaryPath;
    /**
     * 
     */
    @JsonProperty("concurrency")
    @JsonPropertyDescription("")
    private Int32Value concurrency;
    /**
     * 
     */
    @JsonProperty("configPath")
    @JsonPropertyDescription("")
    private java.lang.String configPath;
    @JsonProperty("controlPlaneAuthPolicy")
    private AuthenticationPolicy controlPlaneAuthPolicy;
    /**
     * 
     */
    @JsonProperty("customConfigFile")
    @JsonPropertyDescription("")
    private java.lang.String customConfigFile;
    /**
     * 
     */
    @JsonProperty("discoveryAddress")
    @JsonPropertyDescription("")
    private java.lang.String discoveryAddress;
    /**
     * 
     */
    @JsonProperty("discoveryRefreshDelay")
    @JsonPropertyDescription("")
    private Duration discoveryRefreshDelay;
    /**
     * 
     */
    @JsonProperty("drainDuration")
    @JsonPropertyDescription("")
    private Duration drainDuration;
    /**
     * 
     */
    @JsonProperty("envoyAccessLogService")
    @JsonPropertyDescription("")
    private RemoteService envoyAccessLogService;
    /**
     * 
     */
    @JsonProperty("envoyMetricsService")
    @JsonPropertyDescription("")
    private RemoteService envoyMetricsService;
    /**
     * 
     */
    @JsonProperty("envoyMetricsServiceAddress")
    @JsonPropertyDescription("")
    private java.lang.String envoyMetricsServiceAddress;
    /**
     * 
     */
    @JsonProperty("extraStatTags")
    @JsonPropertyDescription("")
    private List<java.lang.String> extraStatTags = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("gatewayTopology")
    @JsonPropertyDescription("")
    private Topology gatewayTopology;
    @JsonProperty("interceptionMode")
    private InboundInterceptionMode interceptionMode;
    /**
     * 
     */
    @JsonProperty("meshId")
    @JsonPropertyDescription("")
    private java.lang.String meshId;
    /**
     * 
     */
    @JsonProperty("parentShutdownDuration")
    @JsonPropertyDescription("")
    private Duration parentShutdownDuration;
    /**
     * 
     */
    @JsonProperty("proxyAdminPort")
    @JsonPropertyDescription("")
    private Integer proxyAdminPort;
    /**
     * 
     */
    @JsonProperty("proxyBootstrapTemplatePath")
    @JsonPropertyDescription("")
    private java.lang.String proxyBootstrapTemplatePath;
    /**
     * 
     */
    @JsonProperty("proxyMetadata")
    @JsonPropertyDescription("")
    private Map<String, String> proxyMetadata;
    /**
     * 
     */
    @JsonProperty("sds")
    @JsonPropertyDescription("")
    private SDS sds;
    /**
     * 
     */
    @JsonProperty("serviceCluster")
    @JsonPropertyDescription("")
    private java.lang.String serviceCluster;
    /**
     * 
     */
    @JsonProperty("statNameLength")
    @JsonPropertyDescription("")
    private Integer statNameLength;
    /**
     * 
     */
    @JsonProperty("statsdUdpAddress")
    @JsonPropertyDescription("")
    private java.lang.String statsdUdpAddress;
    /**
     * 
     */
    @JsonProperty("statusPort")
    @JsonPropertyDescription("")
    private Integer statusPort;
    /**
     * 
     */
    @JsonProperty("terminationDrainDuration")
    @JsonPropertyDescription("")
    private Duration terminationDrainDuration;
    /**
     * 
     */
    @JsonProperty("tracing")
    @JsonPropertyDescription("")
    private Tracing tracing;
    /**
     * 
     */
    @JsonProperty("zipkinAddress")
    @JsonPropertyDescription("")
    private java.lang.String zipkinAddress;
    private final static long serialVersionUID = 9183650471365309336L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProxyConfig() {
    }

    /**
     * 
     * @param sds
     * @param binaryPath
     * @param statsdUdpAddress
     * @param envoyMetricsService
     * @param configPath
     * @param discoveryAddress
     * @param terminationDrainDuration
     * @param availabilityZone
     * @param controlPlaneAuthPolicy
     * @param zipkinAddress
     * @param statusPort
     * @param proxyMetadata
     * @param proxyBootstrapTemplatePath
     * @param customConfigFile
     * @param parentShutdownDuration
     * @param interceptionMode
     * @param extraStatTags
     * @param tracing
     * @param envoyAccessLogService
     * @param meshId
     * @param statNameLength
     * @param concurrency
     * @param proxyAdminPort
     * @param gatewayTopology
     * @param discoveryRefreshDelay
     * @param drainDuration
     * @param serviceCluster
     * @param envoyMetricsServiceAddress
     */
    public ProxyConfig(java.lang.String availabilityZone, java.lang.String binaryPath, Int32Value concurrency, java.lang.String configPath, AuthenticationPolicy controlPlaneAuthPolicy, java.lang.String customConfigFile, java.lang.String discoveryAddress, Duration discoveryRefreshDelay, Duration drainDuration, RemoteService envoyAccessLogService, RemoteService envoyMetricsService, java.lang.String envoyMetricsServiceAddress, List<java.lang.String> extraStatTags, Topology gatewayTopology, InboundInterceptionMode interceptionMode, java.lang.String meshId, Duration parentShutdownDuration, Integer proxyAdminPort, java.lang.String proxyBootstrapTemplatePath, Map<String, String> proxyMetadata, SDS sds, java.lang.String serviceCluster, Integer statNameLength, java.lang.String statsdUdpAddress, Integer statusPort, Duration terminationDrainDuration, Tracing tracing, java.lang.String zipkinAddress) {
        super();
        this.availabilityZone = availabilityZone;
        this.binaryPath = binaryPath;
        this.concurrency = concurrency;
        this.configPath = configPath;
        this.controlPlaneAuthPolicy = controlPlaneAuthPolicy;
        this.customConfigFile = customConfigFile;
        this.discoveryAddress = discoveryAddress;
        this.discoveryRefreshDelay = discoveryRefreshDelay;
        this.drainDuration = drainDuration;
        this.envoyAccessLogService = envoyAccessLogService;
        this.envoyMetricsService = envoyMetricsService;
        this.envoyMetricsServiceAddress = envoyMetricsServiceAddress;
        this.extraStatTags = extraStatTags;
        this.gatewayTopology = gatewayTopology;
        this.interceptionMode = interceptionMode;
        this.meshId = meshId;
        this.parentShutdownDuration = parentShutdownDuration;
        this.proxyAdminPort = proxyAdminPort;
        this.proxyBootstrapTemplatePath = proxyBootstrapTemplatePath;
        this.proxyMetadata = proxyMetadata;
        this.sds = sds;
        this.serviceCluster = serviceCluster;
        this.statNameLength = statNameLength;
        this.statsdUdpAddress = statsdUdpAddress;
        this.statusPort = statusPort;
        this.terminationDrainDuration = terminationDrainDuration;
        this.tracing = tracing;
        this.zipkinAddress = zipkinAddress;
    }

    /**
     * 
     */
    public java.lang.String getAvailabilityZone() {
        return availabilityZone;
    }

    /**
     * 
     */
    public void setAvailabilityZone(java.lang.String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * 
     */
    public java.lang.String getBinaryPath() {
        return binaryPath;
    }

    /**
     * 
     */
    public void setBinaryPath(java.lang.String binaryPath) {
        this.binaryPath = binaryPath;
    }

    /**
     * 
     */
    public Int32Value getConcurrency() {
        return concurrency;
    }

    /**
     * 
     */
    public void setConcurrency(Int32Value concurrency) {
        this.concurrency = concurrency;
    }

    /**
     * 
     */
    public java.lang.String getConfigPath() {
        return configPath;
    }

    /**
     * 
     */
    public void setConfigPath(java.lang.String configPath) {
        this.configPath = configPath;
    }

    public AuthenticationPolicy getControlPlaneAuthPolicy() {
        return controlPlaneAuthPolicy;
    }

    public void setControlPlaneAuthPolicy(AuthenticationPolicy controlPlaneAuthPolicy) {
        this.controlPlaneAuthPolicy = controlPlaneAuthPolicy;
    }

    /**
     * 
     */
    public java.lang.String getCustomConfigFile() {
        return customConfigFile;
    }

    /**
     * 
     */
    public void setCustomConfigFile(java.lang.String customConfigFile) {
        this.customConfigFile = customConfigFile;
    }

    /**
     * 
     */
    public java.lang.String getDiscoveryAddress() {
        return discoveryAddress;
    }

    /**
     * 
     */
    public void setDiscoveryAddress(java.lang.String discoveryAddress) {
        this.discoveryAddress = discoveryAddress;
    }

    /**
     * 
     */
    public Duration getDiscoveryRefreshDelay() {
        return discoveryRefreshDelay;
    }

    /**
     * 
     */
    public void setDiscoveryRefreshDelay(Duration discoveryRefreshDelay) {
        this.discoveryRefreshDelay = discoveryRefreshDelay;
    }

    /**
     * 
     */
    public Duration getDrainDuration() {
        return drainDuration;
    }

    /**
     * 
     */
    public void setDrainDuration(Duration drainDuration) {
        this.drainDuration = drainDuration;
    }

    /**
     * 
     */
    public RemoteService getEnvoyAccessLogService() {
        return envoyAccessLogService;
    }

    /**
     * 
     */
    public void setEnvoyAccessLogService(RemoteService envoyAccessLogService) {
        this.envoyAccessLogService = envoyAccessLogService;
    }

    /**
     * 
     */
    public RemoteService getEnvoyMetricsService() {
        return envoyMetricsService;
    }

    /**
     * 
     */
    public void setEnvoyMetricsService(RemoteService envoyMetricsService) {
        this.envoyMetricsService = envoyMetricsService;
    }

    /**
     * 
     */
    public java.lang.String getEnvoyMetricsServiceAddress() {
        return envoyMetricsServiceAddress;
    }

    /**
     * 
     */
    public void setEnvoyMetricsServiceAddress(java.lang.String envoyMetricsServiceAddress) {
        this.envoyMetricsServiceAddress = envoyMetricsServiceAddress;
    }

    /**
     * 
     */
    public List<java.lang.String> getExtraStatTags() {
        return extraStatTags;
    }

    /**
     * 
     */
    public void setExtraStatTags(List<java.lang.String> extraStatTags) {
        this.extraStatTags = extraStatTags;
    }

    /**
     * 
     */
    public Topology getGatewayTopology() {
        return gatewayTopology;
    }

    /**
     * 
     */
    public void setGatewayTopology(Topology gatewayTopology) {
        this.gatewayTopology = gatewayTopology;
    }

    public InboundInterceptionMode getInterceptionMode() {
        return interceptionMode;
    }

    public void setInterceptionMode(InboundInterceptionMode interceptionMode) {
        this.interceptionMode = interceptionMode;
    }

    /**
     * 
     */
    public java.lang.String getMeshId() {
        return meshId;
    }

    /**
     * 
     */
    public void setMeshId(java.lang.String meshId) {
        this.meshId = meshId;
    }

    /**
     * 
     */
    public Duration getParentShutdownDuration() {
        return parentShutdownDuration;
    }

    /**
     * 
     */
    public void setParentShutdownDuration(Duration parentShutdownDuration) {
        this.parentShutdownDuration = parentShutdownDuration;
    }

    /**
     * 
     */
    public Integer getProxyAdminPort() {
        return proxyAdminPort;
    }

    /**
     * 
     */
    public void setProxyAdminPort(Integer proxyAdminPort) {
        this.proxyAdminPort = proxyAdminPort;
    }

    /**
     * 
     */
    public java.lang.String getProxyBootstrapTemplatePath() {
        return proxyBootstrapTemplatePath;
    }

    /**
     * 
     */
    public void setProxyBootstrapTemplatePath(java.lang.String proxyBootstrapTemplatePath) {
        this.proxyBootstrapTemplatePath = proxyBootstrapTemplatePath;
    }

    /**
     * 
     */
    public Map<String, String> getProxyMetadata() {
        return proxyMetadata;
    }

    /**
     * 
     */
    public void setProxyMetadata(Map<String, String> proxyMetadata) {
        this.proxyMetadata = proxyMetadata;
    }

    /**
     * 
     */
    public SDS getSds() {
        return sds;
    }

    /**
     * 
     */
    public void setSds(SDS sds) {
        this.sds = sds;
    }

    /**
     * 
     */
    public java.lang.String getServiceCluster() {
        return serviceCluster;
    }

    /**
     * 
     */
    public void setServiceCluster(java.lang.String serviceCluster) {
        this.serviceCluster = serviceCluster;
    }

    /**
     * 
     */
    public Integer getStatNameLength() {
        return statNameLength;
    }

    /**
     * 
     */
    public void setStatNameLength(Integer statNameLength) {
        this.statNameLength = statNameLength;
    }

    /**
     * 
     */
    public java.lang.String getStatsdUdpAddress() {
        return statsdUdpAddress;
    }

    /**
     * 
     */
    public void setStatsdUdpAddress(java.lang.String statsdUdpAddress) {
        this.statsdUdpAddress = statsdUdpAddress;
    }

    /**
     * 
     */
    public Integer getStatusPort() {
        return statusPort;
    }

    /**
     * 
     */
    public void setStatusPort(Integer statusPort) {
        this.statusPort = statusPort;
    }

    /**
     * 
     */
    public Duration getTerminationDrainDuration() {
        return terminationDrainDuration;
    }

    /**
     * 
     */
    public void setTerminationDrainDuration(Duration terminationDrainDuration) {
        this.terminationDrainDuration = terminationDrainDuration;
    }

    /**
     * 
     */
    public Tracing getTracing() {
        return tracing;
    }

    /**
     * 
     */
    public void setTracing(Tracing tracing) {
        this.tracing = tracing;
    }

    /**
     * 
     */
    public java.lang.String getZipkinAddress() {
        return zipkinAddress;
    }

    /**
     * 
     */
    public void setZipkinAddress(java.lang.String zipkinAddress) {
        this.zipkinAddress = zipkinAddress;
    }

}
