package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyConfigBuilder extends ProxyConfigFluentImpl<ProxyConfigBuilder> implements VisitableBuilder<ProxyConfig,ProxyConfigBuilder>{

    ProxyConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyConfigBuilder(){
            this(true);
    }
    public ProxyConfigBuilder(Boolean validationEnabled){
            this(new ProxyConfig(), validationEnabled);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ProxyConfig(), validationEnabled);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance){
            this(fluent, instance, true);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAvailabilityZone(instance.getAvailabilityZone()); 
            fluent.withBinaryPath(instance.getBinaryPath()); 
            fluent.withConcurrency(instance.getConcurrency()); 
            fluent.withConfigPath(instance.getConfigPath()); 
            fluent.withControlPlaneAuthPolicy(instance.getControlPlaneAuthPolicy()); 
            fluent.withCustomConfigFile(instance.getCustomConfigFile()); 
            fluent.withDiscoveryAddress(instance.getDiscoveryAddress()); 
            fluent.withDiscoveryRefreshDelay(instance.getDiscoveryRefreshDelay()); 
            fluent.withDrainDuration(instance.getDrainDuration()); 
            fluent.withEnvoyAccessLogService(instance.getEnvoyAccessLogService()); 
            fluent.withEnvoyMetricsService(instance.getEnvoyMetricsService()); 
            fluent.withEnvoyMetricsServiceAddress(instance.getEnvoyMetricsServiceAddress()); 
            fluent.withExtraStatTags(instance.getExtraStatTags()); 
            fluent.withGatewayTopology(instance.getGatewayTopology()); 
            fluent.withInterceptionMode(instance.getInterceptionMode()); 
            fluent.withMeshId(instance.getMeshId()); 
            fluent.withParentShutdownDuration(instance.getParentShutdownDuration()); 
            fluent.withProxyAdminPort(instance.getProxyAdminPort()); 
            fluent.withProxyBootstrapTemplatePath(instance.getProxyBootstrapTemplatePath()); 
            fluent.withProxyMetadata(instance.getProxyMetadata()); 
            fluent.withSds(instance.getSds()); 
            fluent.withServiceCluster(instance.getServiceCluster()); 
            fluent.withStatNameLength(instance.getStatNameLength()); 
            fluent.withStatsdUdpAddress(instance.getStatsdUdpAddress()); 
            fluent.withStatusPort(instance.getStatusPort()); 
            fluent.withTerminationDrainDuration(instance.getTerminationDrainDuration()); 
            fluent.withTracing(instance.getTracing()); 
            fluent.withZipkinAddress(instance.getZipkinAddress()); 
            this.validationEnabled = validationEnabled; 
    }
    public ProxyConfigBuilder(ProxyConfig instance){
            this(instance,true);
    }
    public ProxyConfigBuilder(ProxyConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAvailabilityZone(instance.getAvailabilityZone()); 
            this.withBinaryPath(instance.getBinaryPath()); 
            this.withConcurrency(instance.getConcurrency()); 
            this.withConfigPath(instance.getConfigPath()); 
            this.withControlPlaneAuthPolicy(instance.getControlPlaneAuthPolicy()); 
            this.withCustomConfigFile(instance.getCustomConfigFile()); 
            this.withDiscoveryAddress(instance.getDiscoveryAddress()); 
            this.withDiscoveryRefreshDelay(instance.getDiscoveryRefreshDelay()); 
            this.withDrainDuration(instance.getDrainDuration()); 
            this.withEnvoyAccessLogService(instance.getEnvoyAccessLogService()); 
            this.withEnvoyMetricsService(instance.getEnvoyMetricsService()); 
            this.withEnvoyMetricsServiceAddress(instance.getEnvoyMetricsServiceAddress()); 
            this.withExtraStatTags(instance.getExtraStatTags()); 
            this.withGatewayTopology(instance.getGatewayTopology()); 
            this.withInterceptionMode(instance.getInterceptionMode()); 
            this.withMeshId(instance.getMeshId()); 
            this.withParentShutdownDuration(instance.getParentShutdownDuration()); 
            this.withProxyAdminPort(instance.getProxyAdminPort()); 
            this.withProxyBootstrapTemplatePath(instance.getProxyBootstrapTemplatePath()); 
            this.withProxyMetadata(instance.getProxyMetadata()); 
            this.withSds(instance.getSds()); 
            this.withServiceCluster(instance.getServiceCluster()); 
            this.withStatNameLength(instance.getStatNameLength()); 
            this.withStatsdUdpAddress(instance.getStatsdUdpAddress()); 
            this.withStatusPort(instance.getStatusPort()); 
            this.withTerminationDrainDuration(instance.getTerminationDrainDuration()); 
            this.withTracing(instance.getTracing()); 
            this.withZipkinAddress(instance.getZipkinAddress()); 
            this.validationEnabled = validationEnabled; 
    }

    public ProxyConfig build(){
            ProxyConfig buildable = new ProxyConfig(fluent.getAvailabilityZone(),fluent.getBinaryPath(),fluent.getConcurrency(),fluent.getConfigPath(),fluent.getControlPlaneAuthPolicy(),fluent.getCustomConfigFile(),fluent.getDiscoveryAddress(),fluent.getDiscoveryRefreshDelay(),fluent.getDrainDuration(),fluent.getEnvoyAccessLogService(),fluent.getEnvoyMetricsService(),fluent.getEnvoyMetricsServiceAddress(),fluent.getExtraStatTags(),fluent.getGatewayTopology(),fluent.getInterceptionMode(),fluent.getMeshId(),fluent.getParentShutdownDuration(),fluent.getProxyAdminPort(),fluent.getProxyBootstrapTemplatePath(),fluent.getProxyMetadata(),fluent.getSds(),fluent.getServiceCluster(),fluent.getStatNameLength(),fluent.getStatsdUdpAddress(),fluent.getStatusPort(),fluent.getTerminationDrainDuration(),fluent.getTracing(),fluent.getZipkinAddress());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ProxyConfigBuilder that = (ProxyConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
